<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head
          titleBinding="TITLE_SAVED_CONFIG@savedConfigBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>

      <uix:form name="savedConfigForm" method="get">
        <uix:formValue name="pageName" value="/ecm/config/savedConfig"/>
        <uix:pageLayout
            titleBinding="HDR_SAVED_CONFIG@savedConfigBundle@servletRequest">

        <%@ include file="/oemGlobal.jspf" %>

          <oem:messageBox messageTypeBinding="errorType@servletRequest"
              titleTextKey="titleText"
              mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

          <uix:stackLayout>
           <uix:tableLayout cellSpacing="5" width="100%">
              <%--- Saved Config Help Text ---%>
              <uix:rowLayout>
              <uix:cellFormat hAlign="left">	
                  <uix:styledText
                      styleClass="OraInstructionText"
                      textBinding="MSG_SAVED_CONFIG@savedConfigBundle@servletRequest"/>
              </uix:cellFormat>
             </uix:rowLayout>

             <uix:rowLayout>
             <uix:contents>
              <uix:tableLayout cellSpacing="5" width="100%" >

                <%--- Search filter ---%>
                <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                <uix:contents>
                    <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                </uix:contents>
                </uix:cellFormat>
                </uix:rowLayout>



                <%--- Saved Configurations result Table ---%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right">
                          <uix:submitButton name="event" value="import"
                              formName="savedConfigForm"
                              textBinding="BTN_IMPORT_CONFIG@savedConfigBundle@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="left">
                    <oem:table name="savedConfigResult" blockSizeBinding="blockSize@defaultBean@servletRequest" width="100%"
                        dataSourceProp="savedConfigResultUI"
                        alternateTextBinding="MSG_NO_ITEMS_FOUND@savedConfigBundle@servletRequest"
                        summaryBinding="SUMMARY_SAVEDCONFIG@savedConfigBundle@servletRequest"
                        showAll="yes">
                      <uix:tableSelection>
                        <uix:singleSelection
                            shortDescBinding="MSG_SELECT_ROW@savedConfigBundle@servletRequest"
                            selectedIndexBinding="selectedIndex@savedConfigBean@servletRequest">
                          <uix:submitButton name="event" value="view"
                              formName="savedConfigForm"
                              textBinding="BTN_VIEW_SAVED_CONFIG@savedConfigBundle@servletRequest"/>
                          <uix:submitButton name="event" value="compare"
                              formName="savedConfigForm"
                              textBinding="BTN_COMPARE_CONFIG@savedConfigBundle@servletRequest"/>
                          <uix:submitButton name="event" value="compareToMultiple"
                              formName="savedConfigForm"
                              textBinding="BTN_COMPARE_MULTIPLE_CONFIG@savedConfigBundle@servletRequest"/>
                          <uix:submitButton name="event" value="export"
                              formName="savedConfigForm"
                              textBinding="BTN_EXPORT_CONFIG@savedConfigBundle@servletRequest"/>
                          <uix:submitButton name="event" value="delete"
                              formName="savedConfigForm"
                              textBinding="BTN_DELETE_CONFIG@savedConfigBundle@servletRequest"/>
                        </uix:singleSelection>
                      </uix:tableSelection>
                      <uix:tableActions>
                          <uix:submitButton name="event" value="multipleDelete"
                              renderedBinding="anyResultsToShow@savedConfigBean@servletRequest"
                              formName="savedConfigForm"
                              textBinding="BTN_MULTIPLE_DELETE_CONFIG@savedConfigBundle@servletRequest"/>
                      </uix:tableActions>

                    </oem:table>
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout>
              </uix:contents>
             </uix:rowLayout>

          </uix:tableLayout>    
          </uix:stackLayout>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
