<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle" />
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>


    <uix:body>

      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <uix:breadCrumbs>
          <uix:contents>
            <uix:link textBinding="TITLE_CSACONFIG@csaBundle"
                      destinationBinding="breadDest@servletRequest"/>
            <uix:link textBinding="header@servletRequest"/>
          </uix:contents>
        </uix:breadCrumbs>

        <oem:messageBox messageType="warning"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="errors@servletRequest"/>

        <uix:form name="refForm" method="get">
          <%--<uix:formValue name="<%= CSAConsts.SEARCH_BEAN_ID_PARAM %>" valueBinding="<%= CSAConsts.SEARCH_BEAN_ID_ATTRIBUTE %>@servletRequest"/>--%>
          <uix:formValue name="searchBeanID" valueBinding="searchBeanID@servletRequest"/>
          <uix:formValue name="rule" valueBinding="rule@servletRequest"/>
          <uix:formValue name="chart" valueBinding="chart@servletRequest"/>
          <uix:formValue name="slice" valueBinding="slice@servletRequest"/>
          <uix:formValue name="other" valueBinding="other@servletRequest"/>
          <uix:formValue name="page" valueBinding="page@servletRequest"/>


          <uix:header textBinding="header@servletRequest">
            <uix:contents>
            <uix:stackLayout>
              <uix:contents>
              
                <uix:spacer height="10"/>
                    
                  <uix:dataScope currentDataBinding="CSAChartDrillBean@servletRequest"> 
                                            
                    <uix:table name="clientList" 
                                   id="clientListID"
                                   partialRenderMode="self"
                                   alternateTextBinding="MSG_PRESSSEARCH@searchBundle"
                                   formSubmitted="true"
                                   width="100%"
                                   minValue="1"
                                   showAll="yes"
                                   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                   summaryBinding="TBLSUM_RESULTSTABLE@searchBundle">
                      <uix:tableFormat tableBanding="rowBanding"/>
        
                      <%-- Client column --%>
                      <uix:column> 
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_CSACLIENT@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_CLIENT %>" />
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_CLIENT %>"
                                  destinationBinding="<%= CSAConsts.S_DEST_CLIENT %>" />
                      </uix:column>
        
                      <%-- Application ID column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_APPLICATIONID@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPID %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_APPID %>"
                                  destinationBinding="<%= CSAConsts.S_DEST_APPID %>" />
                      </uix:column>
         
                       <%-- Overall Compliance column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_OVERALLCOMPLIANCE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OVERALLCOMPLIANCE %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:include nodeBinding="<%= CSAConsts.S_LBL_OVERALLCOMPLIANCE_IMAGE %>" />
                      </uix:column>
           
                      <%--IP address column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_IPADDR@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_IPADDRESS %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_IPADDRESS %>" />
                      </uix:column>
        
                      <%--Timestamp column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_COLLECTDATE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_COLLECTED %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_COLLECTED %>" />
                      </uix:column>
        
                      <%--OS column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_OS@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OPERATINGSYSTEM %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_OPERATINGSYSTEM %>" />
                      </uix:column>
        
                      <%--Hardware column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_HARDWARE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_HARDWARE %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_HARDWARE %>" />
                      </uix:column>
        
                      <%--Browser column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_BROWSER@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_BROWSER %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_BROWSER %>" />
                      </uix:column>
        
                      <%--Latency column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_LATENCY@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_LATENCY %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_LATENCY %>" />
                      </uix:column>
        
                      <%--Bandwidth column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_BANDWIDTH@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_BANDWIDTH %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="numberFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_BANDWIDTH %>" />
                      </uix:column>
        
                      <%-- CSA Collector column --%>
                      <uix:column> 
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_CSACOLLECTOR@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_CSACOLLECTOR %>" />
                          </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_CSACOLLECTOR %>"
                                  destinationBinding="<%= CSAConsts.S_DEST_CSACOLLECTOR %>" />
                      </uix:column>
                
        
        
        
                      <%--DESTINATION URL column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_DESTURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_DESTINATIONURL %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>"
                                  destinationBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>" />
                      </uix:column>
        
                      <%--APPLET URL column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_CSAAPPURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPLETURL %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_APPLETURL %>"
                                  destinationBinding="<%= CSAConsts.S_LBL_APPLETURL %>" />
                      </uix:column>
        
        
                      <%--Proxy Server column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_PROXYSERVER@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_PROXYSERVER %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_PROXYSERVER %>" />
                      </uix:column>
                
                    </uix:table >
                  </uix:dataScope>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
        </uix:form>
      </uix:pageLayout>
   


    </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
