<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<jsp:useBean id="clientBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.CSAClientBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
   	<%@ include file="/oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
      
        <uix:breadCrumbs>
          <uix:contents>
            <uix:link textBinding="targetBreadText@clientBean@servletRequest"
                      destinationBinding="targetDest@clientBean@servletRequest"
                      renderedBinding="renderTargetDest@clientBean@servletRequest"/>
            <uix:link textBinding="breadText@clientBean@servletRequest"
                      destinationBinding="breadDest@clientBean@servletRequest"/>
            <uix:link textBinding="pageHeader@clientBean@servletRequest"/>
          </uix:contents>
        </uix:breadCrumbs>
  
        <oem:messageBox messageType="error"
          titleTextKey="titleText" mainTextKey="mainText"
          errorTableBinding="errors@servletRequest"/>

    
        <uix:header textBinding="pageHeader@clientBean@servletRequest">
          <uix:contents>
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipLabel" textBinding="timeStamp@clientBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:spacer height="20"/>

            <uix:tableLayout hAlign="center">
              <uix:contents>

                <uix:cellFormat vAlign="top">
                  <uix:contents>
                    <uix:tableLayout>
                      <uix:contents>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:contents>
                                <uix:styledText styleClass="OraPromptText" textBinding="LBL_CSACLIENT@CSAResourceBundle"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:spacer width="10"/>
                            <uix:styledText styleClass="OraDataText" textBinding="displayName@clientBean@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:contents>  
                                <uix:styledText styleClass="OraPromptText" textBinding="CSA_APPID@CSAResourceBundle"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:spacer width="10"/>
                            <uix:styledText styleClass="OraDataText" textBinding="appID@clientBean@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:cellFormat>
              </uix:contents>
            </uix:tableLayout>


            <uix:form name="refForm">
              <uix:formValue name="client" valueBinding="client@servletRequest"/>
              <uix:formValue name="tab" valueBinding="tabChoice@servletRequest"/>
              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndex="0">
                    <uix:contents>
                      <uix:link textBinding="GENERAL@CSAResourceBundle"
                                destinationBinding="generalDest@clientBean@servletRequest"/>
                      <uix:link textBinding="LBL_CSA_COMPLIANCE@CSAResourceBundle"
                                destinationBinding="rulesDest@clientBean@servletRequest" />
                      <uix:link textBinding="VENDOR_SNAPSHOT_COMPONENT_NAME@HCResourceBundle"
                                destinationBinding="swDest@clientBean@servletRequest" />
                      <uix:link textBinding="CSA_COOKIES@CSAResourceBundle"
                                destinationBinding="cookieDest@clientBean@servletRequest" />
                      <uix:link textBinding="CSA_CUSTOM_PROPS@CSAResourceBundle"
                                destinationBinding="customDest@clientBean@servletRequest" />
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>
                <uix:contents>

                  <uix:tableLayout hAlign="center">
                    <uix:contents>
      
                      <uix:cellFormat vAlign="top">
                        <uix:contents>
                          <uix:tableLayout>
                            <uix:contents>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right">
                                    <uix:contents>
                                      <uix:spacer height="20"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
      
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HOST@TrackResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="hostName@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="SYSTEM_SUMMARY.DOMAIN@HCResourceBundle"/>
                                    </uix:contents>
                                   </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="domain@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="WINDOWS_DOMAIN@CSAResourceBundle"/>
                                    </uix:contents>
                                   </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="windowsDomain@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                            
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_OS_USERNAME@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="userName@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="IS_ADMIN@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="adminPrivs@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                            
                              <uix:rowLayout renderedBinding="showCK1@clientBean@servletRequest">
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY1@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="customKey1@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                                
                              <uix:rowLayout renderedBinding="showCK2@clientBean@servletRequest">
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY2@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="customKey2@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              
                              <uix:rowLayout  renderedBinding="showCK3@clientBean@servletRequest">
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>  
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY3@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="customKey3@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>  
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_APPID@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="appID@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
      
                          
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat columnSpan="3">
                                    <uix:contents>
                                      <uix:header textBinding="ENTERPRISE_HARDWARE@TrackResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HARDWARE_DETAILS.SYSTEM_CONFIGURATION@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="systemConfig@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HARDWARE_DETAILS.HARDWARE_PROVIDER@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="hardwareProvider@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HARDWARE_DETAILS.NUMBER_OF_CPUS@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="numCPUS@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HARDWARE_DETAILS.AVAIL_MEMORY_SIZE_IN_MB@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="availMem@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="HARDWARE_DETAILS.AVAIL_DISK_SPACE_IN_GB@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="availDisk@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="RELATED_LINK@TrackResourceBundle"/> 
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="HC_HARDWARE_VIEW_HEADER@HCResourceBundle" destinationBinding="hwDetailsLink@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat columnSpan="3">
                                    <uix:contents>
                                      <uix:header textBinding="OS_SUMMARY.OS@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="OS_SUMMARY.OS@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="operatingSystem@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="OS_PATCHES_LBL@TrackResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="numPatches@clientBean@servletRequest" destinationBinding="osPatchesLink@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="RELATED_LINK@TrackResourceBundle"/> 
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="HC_OS_VIEW_HEADER@HCResourceBundle" destinationBinding="osDetailsLink@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                        
                            </uix:contents>
                          </uix:tableLayout>
                        </uix:contents>
                      </uix:cellFormat>
                    
                      <uix:cellFormat vAlign="top">
                        <uix:contents>
                          <uix:spacer width="100"/>
                        </uix:contents>
                      </uix:cellFormat>
                    
                      <uix:cellFormat vAlign="top">
                        <uix:contents>
                          <uix:tableLayout>
                            <uix:contents>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right">
                                    <uix:contents>
                                      <uix:spacer height="20"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>

                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat columnSpan="3">
                                    <uix:contents>
                                      <uix:header textBinding="COLLECTION_ATTRIBUTES@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
 
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="LBL_OVERALLCOMPLIANCE@CSAResourceBundle"/> 
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                      <uix:image sourceBinding="overallCompliance@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
 
                              
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_REF_URL@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="refURL@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>                          
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_URL@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="csaURL@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_APP_URL@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="appURL@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              
      
                              
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOM_PROPS@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="numCustomProps@clientBean@servletRequest" destinationBinding="customDest@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_COLLECTOR_LBL@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="collectorName@clientBean@servletRequest" destinationBinding="collectorDest@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout renderedBinding="showCK3@clientBean@servletRequest">
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>  
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                </uix:contents>
                              </uix:rowLayout>
      
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat columnSpan="3">
                                    <uix:contents>
                                      <uix:header textBinding="HDR_NETWORK@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                            
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_IPADDR@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="ipAddr@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="LBL_CONNECTIONTYPE@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="connectionType@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="LBL_LATENCY@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="latency@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                                
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="LBL_BANDWIDTH@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="bandwidth@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="RELATED_LINK@TrackResourceBundle"/> 
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="HC_NETWORK_BROWSER_VIEW_HEADER@HCResourceBundle" destinationBinding="networkDetailsLink@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat columnSpan="3">
                                    <uix:contents>
                                      <uix:header textBinding="HDR_BROWSER@HCResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSER@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="browser@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="CSA_PROXY@CSAResourceBundle"/>
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:styledText styleClass="OraDataText" textBinding="proxyServer@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
      
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                    <uix:contents>
                                      <uix:styledText styleClass="OraPromptText" textBinding="RELATED_LINK@TrackResourceBundle"/> 
                                    </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="10"/>
                                  <uix:link textBinding="HC_NETWORK_BROWSER_VIEW_HEADER@HCResourceBundle" destinationBinding="browserDetailsLink@clientBean@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                            
      
                            </uix:contents>
                          </uix:tableLayout>
                        </uix:contents>
                      </uix:cellFormat>
      
                    </uix:contents>
                  </uix:tableLayout>

                </uix:contents>
              </uix:subTabLayout>

            </uix:form>
          </uix:contents>
        </uix:header>


      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>


