<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<jsp:useBean id="clientBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.CSAClientBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
   	<%@ include file="/oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
      
        <uix:breadCrumbs>
          <uix:contents>
            <uix:link textBinding="breadText@clientBean@servletRequest"
                      destinationBinding="breadDest@clientBean@servletRequest"/>
            <uix:link textBinding="pageHeader@clientBean@servletRequest"/>
          </uix:contents>
        </uix:breadCrumbs>
  
        <oem:messageBox messageType="error"
          titleTextKey="titleText" mainTextKey="mainText"
          errorTableBinding="errors@servletRequest"/>

    
        <uix:header textBinding="pageHeader@clientBean@servletRequest">
          <uix:contents>
            <uix:rowLayout hAlign="right">
              <uix:cellFormat hAlign="right">
                <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                <uix:spacer width="5"/>
                <uix:styledText styleClass="OraTipLabel" textBinding="timeStamp@clientBean@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:spacer height="20"/>

            <uix:tableLayout hAlign="center">
              <uix:contents>

                <uix:cellFormat vAlign="top">
                  <uix:contents>
                    <uix:tableLayout>
                      <uix:contents>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:contents>
                                <uix:styledText styleClass="OraPromptText" textBinding="LBL_CSACLIENT@CSAResourceBundle"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:spacer width="10"/>
                            <uix:styledText styleClass="OraDataText" textBinding="displayName@clientBean@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>

                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat hAlign="right" wrappingDisabled="true">
                              <uix:contents>  
                                <uix:styledText styleClass="OraPromptText" textBinding="CSA_APPID@CSAResourceBundle"/>
                              </uix:contents>
                            </uix:cellFormat>
                            <uix:spacer width="10"/>
                            <uix:styledText styleClass="OraDataText" textBinding="appID@clientBean@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:cellFormat>
              </uix:contents>
            </uix:tableLayout>


            <uix:form name="refForm">
              <uix:formValue name="client" valueBinding="client@servletRequest"/>
              <uix:formValue name="tab" valueBinding="tabChoice@servletRequest"/>
              <uix:dataScope currentDataBinding="cookiesBean@clientBean@servletRequest">
                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="3">
                      <uix:contents>
                      <uix:link textBinding="GENERAL@CSAResourceBundle"
                                destinationBinding="generalDest@clientBean@servletRequest"/>
                        <uix:link textBinding="CSA_RULES@CSAResourceBundle"
                                  destinationBinding="rulesDest@clientBean@servletRequest" />
                        <uix:link textBinding="VENDOR_SNAPSHOT_COMPONENT_NAME@HCResourceBundle"
                                  destinationBinding="swDest@clientBean@servletRequest" />
                        <uix:link textBinding="CSA_COOKIES@CSAResourceBundle"
                                  destinationBinding="cookieDest@clientBean@servletRequest" />
                        <uix:link textBinding="CSA_CUSTOM_PROPS@CSAResourceBundle"
                                  destinationBinding="customDest@clientBean@servletRequest" />
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:subTabs>
                  <uix:contents>
                    <uix:table name="cookiesTable" 
                               id="cookiesTableID"
                               showAll="yes"
                               partialRenderMode="self"
                               alternateTextBinding="MSG_NODATA@CSAResourceBundle"
                               formSubmitted="true"
                               width="100%"
                               minValue="1"
                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                               summaryBinding="TBLSUM_RESULTSTABLE@CSAResourceBundle">
           
                      <uix:tableFormat tableBanding="rowBanding"/>

                      <%-- NAME column --%>
                      <uix:column> 
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_NAME@CSAResourceBundle" sortableBinding="<%= CSAConsts.S_SORT_NAME %>" />
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_NAME %>" />
                      </uix:column>

                      <%-- value column --%>
                      <uix:column> 
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="VALUE@CSAResourceBundle" sortableBinding="<%= CSAConsts.S_SORT_VALUE %>" />
                        </uix:columnHeader> 
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_VALUE %>" />
                      </uix:column>

                    </uix:table >
                  </uix:contents>
                </uix:subTabLayout>
              </uix:dataScope>
            </uix:form>
          </uix:contents>
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
