<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="collectorBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.CSACollectorBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
   	<%@ include file="/oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <oem:messageBox messageType="error"
                        titleTextKey="titleText" mainTextKey="mainText"
                        errorTableBinding="errors@servletRequest"/>


        <uix:header textBinding="pageHeader@collectorBean@servletRequest">
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="COLLECTOR_TOP_INSTR_TEXT@CSAResourceBundle"/>
                <uix:spacer height="10"/>
                <uix:tableLayout hAlign="center">
                  <uix:contents>
                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>
    
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="HOST@TrackResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:link textBinding="hostName@collectorBean@servletRequest" destinationBinding ="hostDest@collectorBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_UPLOAD_DIR@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="uploadDir@collectorBean@servletRequest"/>
                                <uix:spacer width="10"/>
                                <uix:button textBinding="CSA_UPDATE@CSAResourceBundle" destinationBinding="updateDest@collectorBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
    
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="NUM_COLLECTIONS@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:link textBinding="numClients@collectorBean@servletRequest" destinationBinding="clientsDest@collectorBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:tableLayout>
              </uix:contents>
            </uix:stackLayout>
          </uix:contents>
        </uix:header>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
                          
