<%-- CSA.jsp: Oracle EM Client System Analyzer JSP --%>



<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<jsp:useBean id="tagGenerator" class="oracle.sysman.eml.ecm.csa.CSADeploymentBean"
             scope="request" />


<script language="javascript">

function loadAlert(arg) 
{
    var search = location.search;
    
    if((search != null) && (search != "")) 
    {
        var jvmIdx = search.indexOf("JVM=");
        if(jvmIdx > 0) 
        {
            var qIdx = search.indexOf("&", jvmIdx);
            if(qIdx > jvmIdx)
            {
                //we have to replace whatever the current value is with
                //Sun
                search = search.substring(0, jvmIdx + 4) + arg +
                    search.substring(qIdx);
            }
            else 
            {
                //JVM was the last parameter
                search = search.substring(0, jvmIdx + 4) + arg;
            }
        }
        else 
        {
            //the JVM isn't specified, so we'll just tack it on
            search = search + "&JVM=" + arg;
        }
    }
    else
    {
        search = "?JVM=" + arg;
    }

    location.replace(location.protocol + "//" + location.host + 
        location.pathname + search);
}

function closeWin() {
  //  window.close();
}

function reFocus() {
    if(window.opener != null) 
    {
        window.opener.focus();
    }
}


<%    
        int uiMode = tagGenerator.getUIMode();
        if(uiMode > 0) 
        {
            long timeout = 0;
            if(uiMode == 1)
            {
                timeout = tagGenerator.getVisibleTimeout();
            }
            else 
            {
                timeout = tagGenerator.getInvisibleTimeout();
            }
            if(timeout > 0)
            {
%>

setTimeout('window.close()', <%= timeout %>);

<%
            }
        }
%>


</script>




<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:image source="/em/ecm/csa/csabanner.gif"/>
  <uix:document> 
    <uix:metaContainer>
      <uix:head titleBinding="csaTitle@servletRequest">
        <uix:rawText> 
          <meta http-equiv="Cache-Control" content="max-age=0">
        </uix:rawText> 
      </uix:head>
    </uix:metaContainer>

    <uix:body>
      <uix:pageLayout>

        <uix:stackLayout>
          <uix:contents>

            <uix:styledText textBinding="description@tagGenerator@servletRequest"
                            styleClass="OraInstructionText"/>

            <uix:rawText textBinding="deploymentTag@tagGenerator@servletRequest"/>

            <uix:link renderedBinding="showDestURL@tagGenerator@servletRequest"
                      textBinding="destURLText@tagGenerator@servletRequest"
                      destinationBinding="destURL@tagGenerator@servletRequest"/>
          </uix:contents>
        </uix:stackLayout>

      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
