
<%-- CSA Receiver Page.jsp: Oracle EM Client System Analyzer "receiver" --%>

<%@ page language="java" contentType="text/html" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.net.*" %>
<%@ page import = "java.util.Enumeration" %>

<%-- TEST ONLY imports ... --%>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>
<%@ page import = "java.io.FileInputStream" %>
<%@ page import = "java.io.InputStreamReader" %>
<%@ page import = "oracle.sysman.eml.ecm.csa.CSAReceiverBean" %>

<jsp:useBean id="processor" class="oracle.sysman.eml.ecm.csa.CSAReceiverBean"/>

<%
    String CSA_CONFIG_FILE_PATH = "CSA_CONFIG_FILE_PATH";
    String csaJavaProperty = "csa.config_file_path";
    String PASSED_DTD_FILE = "csa.dtd";
    String FAILED_DTD_FILE = "failedcsa.dtd";

    processor.init(application, request, response);
    if(!processor.isIPAddressAllowed()) 
    {
        response.sendError(response.SC_UNAUTHORIZED, "The client's IP address" +
            " is in a range that has been excluded by the administrator");
    }
    else 
    {
        // TBD: Specify no caching of JSP page???
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 1);
%>
<html>
<head>
<title>Oracle EM Client System Analyzer "receiver" </title>
</head>
<body>
<%
    
        String httpMethod = request.getMethod();
        int    contentLen = request.getContentLength();
    
    
        if (httpMethod.equals("POST") && (contentLen > 0))
        {
            int code = processor.processPost(application, request, response);
            
            if(code != CSAReceiverBean.OUTPUT_DIR_ERR_CODE) 
            {
                processor.cleanDir();
            }
%>
<p>csaPostStatus=<%= code %>
<%

        }
%>
</body>
</html>
<%
    }//end else IP address is allowed
%>
