
<%-- csaCookies.jsp: CSA Cookie Test --%>

<%@ page language="java" contentType="text/html" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.net.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>

<html>
<head><title>CSA Cookie Test</title></head>
<body>
<%
  // TBD???: Specify no caching of JSP page ...
  response.setHeader("Pragma", "No-cache");
  response.setHeader("Cache-Control", "no-cache");
  response.setDateHeader("Expires", 1);


  String   cookieName = "ORA_SMP_CSA";  // Oracle EM Client System Analyzer
  String   cookieValue = "";
  Cookie[] cookies  = request.getCookies();
  Cookie   aCookie    = null;
  Cookie   newCookie  = null;
  int      nCookies = ((cookies == null) ? 0 : cookies.length);
  int      ii;
  int      csaCookieCnt = 0;
  String   serverName  = request.getServerName();
  int      snLen       = 0;
  int      idx         = 0;

  // Setup formatted timestamp string for use as part of cookieValue ...
  Date             currDate = new Date();
  SimpleDateFormat sdf      = new SimpleDateFormat("yyyy-MM-dd H:mm:ss (z)");
  String           ts       = sdf.format(currDate);
  StringBuffer     cvBuff   = new StringBuffer(100);    // for new cookie value

  long    currTS       = System.currentTimeMillis();
  String  msec         = new String().valueOf(currTS);
  long    prevTS       = 0;        // for an existing cookie, if any
  long    cookieAge    = 0;        // diff between prevTS and currTS (in msec)


  // Define defaults for several cookie attributes, etc, and then
  // determine if any non-default values are provided ...
  int     cookieMaxAge = 600*1;          // expires after 60 seconds 
  String  cookiePath   = "/aks";
  //String cookiePath = request.getParameter("path");
  String  cookieDomain = "oracle.com";
  //String cookieDomain = request.getParameter("domain");
  String  currPath = "";                // for an existing cookie, if any


  // Does a client config cookie already exist?...
  for (ii = 0; ii < nCookies; ii++)
  {
    aCookie = cookies[ii];
    if (aCookie.getName().equals(cookieName))
    {
      cookieValue = aCookie.getValue();
    %> <P> found cookie on iteration <%= ii %> </p> <%
      if ((idx = cookieValue.indexOf("[")) > 0)
      {
        try
        {
          prevTS = Long.parseLong(cookieValue.substring(0,idx));
          cookieAge = currTS - prevTS;
%>
<P> Found CSA cookie <%= cookieValue %>, with age = <%= cookieAge %> msec </P>
<%
        }
        catch (Exception e)
        {
%>
<P> Found CSA cookie <%= cookieValue %>, but exception finding its age </P>
<%
        }
      }
      else
      {
%>
<P> Found CSA cookie <%= cookieValue %>, but cannot determine its age </P>
<%
      }

      // Do NOT remove the current existing cookie ...
//    aCookie.setMaxAge(0);
//    response.addCookie(aCookie);

      csaCookieCnt++;
    }
  }

  // If client config cookie was found ...
  if (csaCookieCnt > 0)
  {
%>
<P> Found total of <%= csaCookieCnt %> CSA cookie(s) </P>
<%
  }
  else
  {
%>
<P> Found no CSA cookies </P>
<%
  }


  // Setup new cookieValue for cookie to be created ...
  // eg "1056644836107[jmcd]2003-06-26 12:27:16 (EDT)[dom][path]"
  //cvBuff.append(currTS + "[");
  cvBuff.append(currTS + "" + currTS);
  if ((serverName != null) && !serverName.equals(""))
  {
    if ((snLen = serverName.length()) >= 4)
    {
//      cvBuff.append(serverName.substring(0,4));
    }
    else
    {
  //    cvBuff.append(serverName);
    }
  }
//  cvBuff.append("]" + ts);

  if ((cookieDomain != null) && !cookieDomain.equals(""))
  {
  //  cvBuff.append("" + cookieDomain);
  }
  if ((cookiePath != null) && !cookiePath.equals(""))
  {
    //cvBuff.append(cookiePath);
  }
  cookieValue = cvBuff.toString();


  // Set replacement cookie ...
  newCookie = new Cookie(cookieName,
                         cookieValue);
  newCookie.setMaxAge(cookieMaxAge);
  if ((cookiePath != null) && !cookiePath.equals(""))
  {
    newCookie.setPath(cookiePath);
  }
  if ((cookieDomain != null) && !cookieDomain.equals(""))
  {
    newCookie.setDomain(cookieDomain);
  }
%>
<P> Add new CSA cookie with value <%= cookieValue %> ... </P>
<p> cookie domain is <%= cookieDomain %> and cookie path is <%= cookiePath %> </p>
<%
  response.addCookie(newCookie);
%>
</body>
</html>

