<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  <uix:bundle name="commonBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>


    <uix:body>

    

    <uix:form name="deleteForm" method="get">
      <uix:formValue name="<%= CSAConsts.SEARCH_BEAN_ID_PARAM %>" valueBinding="beanID@servletRequest"/>
      <uix:formValue name="type" valueBinding="type@servletRequest"/>
      <uix:formValue name="collectionTag" valueBinding="collectionTag@servletRequest"/>

      <uix:pageLayout>
           
           
          <oem:messageBox messageType="error"
          titleTextKey="titleText" mainTextKey="mainText"
          errorTableBinding="errors@servletRequest"/>


           
          <uix:pageButtons>
            
              <uix:rowLayout>
                <uix:contents>
                  <uix:submitButton name="event" 
                                    value="cancel" 
                                    textBinding="BTN_NO@csaBundle"/>
                  <uix:spacer width="10"/>
                  <uix:submitButton name="event" 
                                    value="delete" 
                                    textBinding="BTN_YES@csaBundle"/>
                </uix:contents>
              </uix:rowLayout>
            
          </uix:pageButtons>

          <uix:pageStatus>
          </uix:pageStatus>

          <%@ include file="/oemGlobal.jspf" %>
          
          <uix:header icon="/em/images/confirmation.gif"   
                      textBinding="WARNING@commonBundle">

            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionTextStrong" 
                                  textBinding="confirmText@servletRequest"/>
                  <uix:spacer height="20"/>
                  <uix:include nodeBinding="detailsNode@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
          
        </uix:pageLayout>
    </uix:form>
    </uix:body>
    </uix:document>
    </uix:renderingContext>
