<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body onLoad="launchIASControl()">
    
    <script language="JavaScript"><!--
    function launchIASControl()
    {
        var launch = document.launchForm.launch.value;
        var url = document.launchForm.url.value;
        if(launch == "yes")
        {
            //openWindow(window, url, 'selectUserRoleWindow', {width:750,height:550},true,'dialog',myCallBack);   
            openWindow(top, url);
        }
    }
    function myCallBack()
    {
    } 

    --></script>
    <uix:form name="launchForm" method="POST">
      <uix:formValue name="launch" valueBinding="launch@servletRequest"/>
      <uix:formValue name="url" valueBinding="url@servletRequest"/>
    </uix:form>
    
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        <uix:breadCrumbs>
          <uix:contents>
            <uix:link textBinding="GETTING_STARTED@csaBundle"
                      destinationBinding="breadDest@servletRequest"/>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="DEPLOY_CSA@csaBundle"/>
          </uix:contents>
        </uix:breadCrumbs>

        
        <oem:messageBox messageType="error"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="errors@servletRequest"/>
        <oem:messageBox messageType="info"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="info@servletRequest"/>

        <uix:form name="refForm" 
                  method="GET">

          <uix:header textBinding="DEPLOY_CSA@csaBundle">
            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="GS_TOP_INSTR_TEXT_1@csaBundle"/>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="DEPLOY_TOP_INSTR_TEXT@csaBundle"/>
                  <uix:spacer height="10"/>
                  
                  <uix:header textBinding="STEP1@csaBundle">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>


                          <uix:rowLayout hAlign="left">
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText" 
                                              textBinding="DOWNLOAD_APP_INSTR_TEXT@csaBundle"/>
                              <uix:spacer width="10"/>
                              <uix:submitButton textBinding="DOWNLOAD_APP_BUTTON_TEXT@csaBundle"
                                                formName="refForm"
                                                name="event"
                                                value="downloadApp"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <uix:spacer height="30"/>
                          <uix:rowLayout hAlign="left">
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="APP_INSTR_LINE1@csaBundle"/>
                            </uix:contents>
                          </uix:rowLayout>
                          <uix:spacer height="20"/>
                          <uix:bulletedList>
                            <uix:contents>



                              <uix:rowLayout vAlign="botton">
                                <uix:contents>
                                  <uix:cellFormat vAlign="bottom">
                                  <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="APP_INSTR_LINE2@csaBundle"/>
                                  </uix:contents>
                                  </uix:cellFormat>
                                  <uix:spacer width="5"/>
                                  <uix:cellFormat vAlign="top">
                                  <uix:contents>
                                    <uix:image source="/em/images/infoicon_active.gif"
                                               destinationBinding="appInstrDest2@servletRequest"/>
                                  </uix:contents>
                                  </uix:cellFormat>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="APP_INSTR_LINE3@csaBundle"/>
                                  <uix:spacer width="5"/>
                                  <uix:image source="/em/images/infoicon_active.gif"
                                            destinationBinding="appInstrDest3@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="APP_INSTR_LINE4@csaBundle"/>
                                  <uix:spacer width="5"/>
                                  <uix:image source="/em/images/infoicon_active.gif"
                                            destinationBinding="appInstrDest4@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="APP_INSTR_LINE5@csaBundle"/>
                                  <uix:spacer width="5"/>
                                  <uix:image source="/em/images/infoicon_active.gif"
                                            destinationBinding="appInstrDest5@servletRequest"/>
                                </uix:contents>
                              </uix:rowLayout>

                            </uix:contents>
                          </uix:bulletedList>
                          
                          
                          <uix:spacer height="10"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="OBTAIN_APP_MOREINFO@csaBundle"/>
                              <uix:spacer width="5"/>
                              <uix:image source="/em/images/infoicon_active.gif"
                                        destinationBinding="obtainAppMoreinfoDest@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>
                  
                  <uix:spacer height="10"/>
                  
                  
                  
                  <uix:header textBinding="STEP2@csaBundle">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                              <uix:styledText textBinding="DEPLOY_INSTR_TEXT@csaBundle"
                                              styleClass="OraInstructionText"/>
                          
                              <oem:targetSelection textBinding="DEPLOY_TEXT@csaBundle" event="selectIAS"/>
                          <uix:spacer height="5"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="DEPLOY_MOREINFO@csaBundle"/>
                              <uix:spacer width="5"/>
                              <uix:image source="/em/images/infoicon_active.gif"
                                         destinationBinding="deployMoreinfoDest@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>

                  
                  <uix:header textBinding="STEP3@csaBundle">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="REDIRECT_USER_INSTR_TEXT@csaBundle"/>
                          <uix:spacer height="10"/>
                          <uix:bulletedList>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="REDIR_LINE1@csaBundle"/>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="REDIR_LINE2@csaBundle"/>
                                  <uix:spacer width="5"/>
                                  <uix:submitButton textBinding="DOWNLOAD_FILTER_BUTTON_TEXT@csaBundle"
                                                    formName="refForm"
                                                    name="event"
                                                    value="downloadFilter"/>
                                </uix:contents>
                              </uix:rowLayout>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:styledText styleClass="OraInstructionText"
                                                  textBinding="REDIR_LINE3@csaBundle"/>
                                  <uix:spacer width="5"/>
                                  <uix:submitButton textBinding="DOWNLOAD_JSP_BUTTON_TEXT@csaBundle"
                                                    formName="refForm"
                                                    name="event"
                                                    value="downloadJSP"/>
                                </uix:contents>
                              </uix:rowLayout>
                            </uix:contents>
                          </uix:bulletedList>
                          <uix:spacer height="5"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="REDIR_MOREINFO@csaBundle"/>
                              <uix:spacer width="5"/>
                              <uix:image source="/em/images/infoicon_active.gif"
                                         destinationBinding="redirMoreinfoDest@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>                            
                            
                  <uix:header textBinding="STEP4@csaBundle">
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="CONFIGURE_EM_INSTR_TEXT@csaBundle"/>
                          <uix:spacer height="5"/>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="ADD_COLLECTOR_INSTR_TEXT@csaBundle"/>
                          
                          <oem:targetSelection textBinding="ADD_COLLECTOR_TEXT@csaBundle" event="addCollector"/>
                          <uix:spacer height="5"/>
                          <uix:rowLayout>
                            <uix:contents>
                              <uix:styledText styleClass="OraInstructionText"
                                              textBinding="ADD_COLLECTOR_MOREINFO@csaBundle"/>
                              <uix:spacer width="5"/>
                              <uix:image source="/em/images/infoicon_active.gif"
                                        destinationBinding="addCollectorMoreinfoDest@servletRequest"/>
                            </uix:contents>
                          </uix:rowLayout>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>
                  <uix:header textBinding="STEP5@csaBundle"> 
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="TEST_INSTR_TEXT@csaBundle"/>
                          <uix:spacer height="10"/>
                          <uix:link textBinding="SEARCH_COLLECTIONS@csaBundle"
                                    destinationBinding="clientConfigLink@servletRequest"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:header>

                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
        </uix:form>       
      </uix:pageLayout>
   </uix:body>
  </uix:document>
</uix:renderingContext>
