<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="failedCollectionBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.FailedCollectionBean"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>

              
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
				
        <uix:stackLayout>
          <uix:contents>
            <uix:breadCrumbs>
              <uix:contents>
                <uix:link textBinding="SEARCH_FAILED_COLLECTIONS@csaBundle"
                          destinationBinding="breadDest@failedCollectionBean@servletRequest"/>
                <uix:styledText textBinding="FAILED_COLLECTION_HDR@csaBundle"/>
              </uix:contents>
            </uix:breadCrumbs>

            <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

            <uix:header textBinding="FAILED_COLLECTION_HDR@csaBundle">
              <uix:contents>
                <uix:rowLayout hAlign="right" vAlign="bottom">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="CSA_COLLECTION_TIMESTAMP@csaBundle"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="capturedTime@failedCollectionBean@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:spacer height="20"/>

                <uix:rowLayout hAlign="center">
                  <uix:contents>
                    <uix:labeledFieldLayout fieldWidth="0" labelWidth="0" width="0">
                      <uix:contents> 

                        <uix:styledText 
                          textBinding="LBL_EFF_IP_ADDR@csaBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="effIPAddr@failedCollectionBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          textBinding="LBL_APPLICATIONID@csaBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="appID@failedCollectionBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          textBinding="LBL_CSAAPPURL@csaBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="csaURL@failedCollectionBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          textBinding="LBL_REFURL@csaBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="refURL@failedCollectionBean@servletRequest" 
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_DESTURL@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="destURL@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_BROWSER@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="browser@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_JVM@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="JVM@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_OSNAME@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="osName@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_OSARCH@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="osArch@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_CAUSE@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="cause@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_ERRORTEXT@csaBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="errorText@failedCollectionBean@servletRequest"
                          styleClass="OraDataText" />

                      </uix:contents>
                    </uix:labeledFieldLayout>

                  </uix:contents>
                </uix:rowLayout>
              </uix:contents>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
                  
                  
