<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>
             

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
      <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="post">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>
  
          <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>
  
          <oem:messageBox messageType="warning"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="warnings@servletRequest"/>

          <oem:messageBox messageType="info"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="rowMsg@servletRequest"/>
  
  
          <uix:header textBinding="FAILED_HDR@csaBundle">
            <uix:contents>
              <uix:stackLayout>
                <uix:contents>
                  <uix:rowLayout hAlign="right">
                    <oem:pageRefreshed/>
                    <uix:submitButton 
                                textBinding="BTN_SQLSEARCH@csaBundle"
                                name="event"
                                value="sqlSearch"
                                formNameBinding="eml_ecm_sc_formName@servletRequest"/>
                  </uix:rowLayout>
                  <uix:spacer height="20"/> 

                  <uix:rowLayout hAlign="left">
                    <uix:styledText styleClass="OraPromptText"
                                    textBinding="NUM_FAILED_COLS@csaBundle"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="failedCols@servletRequest"/>
                  </uix:rowLayout>
                  <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                  <uix:spacer height="20"/>

                  
                  <uix:dataScope currentDataBinding="failedCollectionsBean@servletRequest">
                    <uix:table name="failedColsTable"
                               showAll="yes"
                               id="failedColsTableID"
                               partialRenderMode="self"
                               alternateTextBinding="NO_DATA@csaBundle"
                               formSubmitted="true"
                               width="100%"
                               minValue="1"
                               tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                               valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                               maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                               blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                               summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
                      
                      <uix:tableFormat tableBanding="rowBanding"/>
                      <uix:tableSelection>
                        <uix:multipleSelection shortDescBinding="MULTISEL_RESULTSTABLE@csaBundle">
                          <uix:contents>
                            <uix:submitButton name="event" value="deleteConfirm" textBinding="BTN_DELETE@csaBundle"/>
                          </uix:contents>
                        </uix:multipleSelection>
                      </uix:tableSelection>
                               
                      <%-- Effective IP Addr Column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_EFF_IP_ADDR@csaBundle"
                                              sortableBinding="<%= CSAConsts.S_SORT_EFF_IP_ADDR %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_EFF_IP_ADDR %>"/>
                      </uix:column>
                      
                      <%-- Timestamp Column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_COLLECTDATE@csaBundle"
                                              sortableBinding="<%= CSAConsts.S_SORT_COLLECTDATE %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_COLLECTDATE %>"/>
                      </uix:column>
                      
                      <%-- Cause column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_CAUSE@csaBundle"
                                              sortableBinding="<%= CSAConsts.S_SORT_CAUSE %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_CAUSE %>" />
                      </uix:column>
                      
                      <%-- Collection Tag column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_APPLICATIONID@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPID %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_APPID %>"
                                  destinationBinding="<%= CSAConsts.S_DEST_APPID %>" />
                      </uix:column>
                      
                      <%--APPLET URL column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_CSAAPPURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPLETURL %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_APPLETURL %>"
                                  destinationBinding="<%= CSAConsts.S_LBL_APPLETURL %>" />
                      </uix:column>
                                            
                      <%--DESTINATION URL column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_DESTURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_DESTINATIONURL %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>"
                                  destinationBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>" />
                      </uix:column>
  
                      <%--REF URL column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_REFURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_REFURL %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:link textBinding="<%= CSAConsts.S_LBL_REFURL %>"
                                  destinationBinding="<%= CSAConsts.S_LBL_REFURL %>" />
                      </uix:column>
  
                      <%--Browser column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_BROWSER@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_BROWSER %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_BROWSER %>" />
                      </uix:column>
  
                      <%-- JVM column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_JVM@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_JVM %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_JVM %>" />
                      </uix:column>
                      
                      <%-- OS.name column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_OSNAME@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OSNAME %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_OSNAME %>" />
                      </uix:column>
  
                      <%-- OS.arch column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="LBL_OSARCH@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OSARCH %>" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat"/>
                        <uix:styledText textBinding="<%= CSAConsts.S_LBL_OSARCH %>" />
                      </uix:column>

                      <%-- details column --%>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="DETAILS@csaBundle"/>
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                        <uix:image source="/em/images/updateicon_enabled.gif" 
                                  destinationBinding="<%= CSAConsts.S_DEST_FAILED %>" />
                      </uix:column>
                      
                    </uix:table>
                  </uix:dataScope>
                </uix:contents>
              </uix:stackLayout>
            </uix:contents>
          </uix:header>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
