<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  <uix:bundle name="TrackResourceBundle"
              class="oracle.sysman.eml.ecm.resources.TrackResourceBundle"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        
        <oem:messageBox messageType="error"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="errors@servletRequest"/>
        <oem:messageBox messageType="info"
            titleTextKey="titleText" mainTextKey="mainText"
            errorTableBinding="info@servletRequest"/>

        <uix:header textBinding="GETTING_STARTED@csaBundle">
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:styledText styleClass="OraInstructionText"
                                textBinding="GS_TOP_INSTR_TEXT_1@csaBundle"/>
                <uix:spacer height="5"/>
                <uix:styledText styleClass = "OraInstructionText"
                                textBinding="GS_TOP_INSTR_TEXT_2@csaBundle"/>
                <uix:spacer height="10"/>

                
                <uix:header textBinding="OOB_APP@csaBundle">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="GS_OOB_INSTR_TEXT1@csaBundle"/>

                        <uix:spacer height="5"/>
                        <uix:bulletedList>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="GS_OOB_BULLET1@csaBundle"/>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="GS_OOB_BULLET2@csaBundle"/>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="GS_OOB_BULLET3@csaBundle"/>
                          </uix:contents>
                        </uix:bulletedList>
                        <uix:spacer height="5"/>
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="GS_OOB_INSTR_TEXT2@csaBundle"/>
                        <uix:spacer height="5"/>                
                        <uix:link textBinding="OUT_OF_BOX_HDR@csaBundle"
                                  destinationBinding="manageOOBDest@servletRequest"/>

                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:header>
                
                <uix:spacer height="10"/>
                
                <uix:header textBinding="DEPLOY_CSA@csaBundle">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText textBinding="GS_DEPLOY_INSTR_TEXT@csaBundle"
                                        styleClass="OraInstructionText"/>
                        
                        <uix:spacer height="1"/>
                        <uix:bulletedList>
                          <uix:contents>
                            <uix:styledText textBinding="GS_DEPLOY_BULLET1@csaBundle"
                                            styleClass="OraInstructionText"/>
                            <uix:styledText textBinding="GS_DEPLOY_BULLET2@csaBundle"
                                            styleClass="OraInstructionText"/>
                            <uix:bulletedList>
                              <uix:contents>
                                <uix:styledText textBinding="GS_DEPLOY_BULLET3@csaBundle"
                                                styleClass="OraInstructionText"/>
                                <uix:styledText textBinding="GS_DEPLOY_BULLET4@csaBundle"
                                                styleClass="OraInstructionText"/>
                              </uix:contents>
                            </uix:bulletedList>
                          </uix:contents>
                        </uix:bulletedList>
                        <uix:spacer height="5"/>
                        <uix:link textBinding="DEPLOY_CSA@csaBundle"
                                  destinationBinding="deployCSADest@servletRequest"/>

                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:header>
                
                <uix:spacer height="10"/>
                
                <uix:header textBinding="CURRENT_ASSOC_HDR@csaBundle">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="GS_COLLECTION_TAG_INSTR_TEXT@csaBundle"/>
                        <uix:spacer height="5"/>
                        <uix:bulletedList>
                          <uix:contents>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="GS_COLLECTION_TAG_BULLET_1@csaBundle"/>
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="GS_COLLECTION_TAG_BULLET_2@csaBundle"/>
                          </uix:contents>
                        </uix:bulletedList>
                        <uix:spacer height="5"/>
                        <uix:link textBinding="CURRENT_ASSOC_HDR@csaBundle"
                                  destinationBinding="collectionTagDest@servletRequest"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:header>  
              
              </uix:contents>
            </uix:stackLayout>
          </uix:contents>
        </uix:header>
      </uix:pageLayout>
   </uix:body>
  </uix:document>
</uix:renderingContext>
