<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="hardwareDetailsBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.HardwareDetailsBean"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
        
		<uix:stackLayout>
          <uix:contents>
            <uix:breadCrumbs>
              <uix:contents>
                <uix:link textBinding="breadText@hardwareDetailsBean@servletRequest"
                          destinationBinding="breadDest@hardwareDetailsBean@servletRequest"/>
                <uix:link textBinding="HC_HARDWARE_VIEW_HEADER@HCResourceBundle"/>
              </uix:contents>
            </uix:breadCrumbs>


            <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>


            <uix:header textBinding="HC_HARDWARE_VIEW_HEADER@HCResourceBundle">
              <uix:contents>
                <uix:rowLayout hAlign="right" vAlign="bottom">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraTipLabel" textBinding="capturedTime@hardwareDetailsBean@servletRequest"/>
                        <uix:spacer width="8"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>

                <uix:spacer height="20"/>
                
                <uix:rowLayout hAlign="center">
                  <uix:contents>
                    <uix:labeledFieldLayout fieldWidth="0" labelWidth="0" width="0">
                      <uix:contents> 
                        <uix:styledText 
                          textBinding="LBL_CSACLIENT@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="clientName@hardwareDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK1@hardwareDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY1@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK1@hardwareDetailsBean@servletRequest"
                          textBinding="customKey1@hardwareDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK2@hardwareDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY2@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK2@hardwareDetailsBean@servletRequest"
                          textBinding="customKey2@hardwareDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK3@hardwareDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY3@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK3@hardwareDetailsBean@servletRequest"
                          textBinding="customKey3@hardwareDetailsBean@servletRequest" 
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_APPLICATIONID@CSAResourceBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="appID@hardwareDetailsBean@servletRequest"
                          styleClass="OraDataText" />
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:contents>  
                </uix:rowLayout>
                <uix:spacer height="20"/>

                <uix:tableLayout hAlign="center">
                  <uix:contents>
                    <uix:cellFormat vAlign="top">
                      <uix:contents>

                        <uix:labeledFieldLayout fieldWidth="0" labelWidth="200" width="0">
                          <uix:contents> 

                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.SYSTEM_CONFIGURATION@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="systemConfiguration@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText" /> 
                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.MACHINE_ARCHITECTURE@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="machineArchitecture@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 


                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.AVAIL_MEMORY_SIZE_IN_MB@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="availMemory@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 


                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.AVAIL_DISK_SPACE_IN_GB@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="availLocalDiskSpace@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 

                            <uix:styledText 
                              textBinding="LBL_CPU@CSAResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="processorArch@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 


                          </uix:contents>
                        </uix:labeledFieldLayout>
                            
                      </uix:contents>
                    </uix:cellFormat>

                    <uix:cellFormat>
                      <uix:contents>
                        <uix:spacer width="20"/>
                      </uix:contents>
                    </uix:cellFormat>

                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:labeledFieldLayout fieldWidth="0" labelWidth="200" width="0">
                          <uix:contents> 

                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.HARDWARE_PROVIDER@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="hardwareProvider@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 

                            <uix:styledText 
                              renderedBinding="showClockFrequency@hardwareDetailsBean@servletRequest"
                              textBinding="HARDWARE_DETAILS.CLOCK_FREQUENCY_IN_MHZ@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              renderedBinding="showClockFrequency@hardwareDetailsBean@servletRequest"
                              textBinding="clockFrequency@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 
                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.NUMBER_OF_CPUS@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="numberOfCPUs@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText" /> 
                            <uix:styledText
                              renderedBinding="showNumberOfCPUBoards@hardwareDetailsBean@servletRequest"
                              textBinding="HARDWARE_DETAILS.NUMBER_OF_CPU_BOARDS@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              renderedBinding="showNumberOfCPUBoards@hardwareDetailsBean@servletRequest"
                              textBinding="numberOfCPUBoards@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 
                            <uix:styledText 
                              textBinding="HARDWARE_DETAILS.NUMBER_OF_IO_DEVICES@HCResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="numberOfIODevices@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 
                            <uix:styledText 
                              textBinding="CSA_SYSTEM_BIOS@CSAResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="bios@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 
                            <uix:styledText 
                              textBinding="SYSTEM_SERIAL_NUM@CSAResourceBundle" 
                              styleClass="OraPromptText" /> 
                            <uix:styledText 
                              textBinding="systemSerialNum@hardwareDetailsBean@servletRequest" 
                              styleClass="OraDataText"/> 
                              

                          </uix:contents>
                        </uix:labeledFieldLayout>

                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:tableLayout>


                <uix:header textBinding="SUBCOMPONENT.CPU@HCResourceBundle">
                  <uix:contents>

<!-- CPU's table node -->
                    <uix:include nodeBinding="cpuTable@hardwareDetailsBean@servletRequest"/>
            
                  </uix:contents>
                </uix:header>

                <uix:header textBinding="SUBCOMPONENT.IO_DEVICES@HCResourceBundle">
                  <uix:contents>

<!-- IO Devices table node -->
                    <uix:include nodeBinding="ioDevicesTable@hardwareDetailsBean@servletRequest"/>
                                          
                  </uix:contents>
                </uix:header>

                <uix:header textBinding="SUBCOMPONENT.NETWORK_INTERFACE_CARD@HCResourceBundle">
                  <uix:contents>

<!-- Network Interfaces table node -->
                    <uix:include nodeBinding="networkInterfacesTable@hardwareDetailsBean@servletRequest"/>
                                          
                  </uix:contents>
                </uix:header>

              </uix:contents>
            </uix:header>

          </uix:contents>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>


