<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="networkDetailsBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.NetworkDetailsBean"/>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>

              
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
				
        <uix:stackLayout>
          <uix:contents>
            <uix:breadCrumbs>
              <uix:contents>
                <uix:link textBinding="breadText@networkDetailsBean@servletRequest"
                          destinationBinding="breadDest@networkDetailsBean@servletRequest"/>
                <uix:link textBinding="HC_NETWORK_BROWSER_VIEW_HEADER@HCResourceBundle"/>
              </uix:contents>
            </uix:breadCrumbs>

            <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>


            <uix:header textBinding="HC_NETWORK_BROWSER_VIEW_HEADER@HCResourceBundle">
              <uix:contents>
                <uix:rowLayout hAlign="right" vAlign="bottom">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraTipLabel" textBinding="capturedTime@networkDetailsBean@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                
                <uix:spacer height="20"/>

                <uix:rowLayout hAlign="center">
                  <uix:contents>

                    <uix:labeledFieldLayout fieldWidth="0" labelWidth="0" width="0">
                      <uix:contents> 

                        <uix:styledText 
                          textBinding="LBL_CSACLIENT@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          textBinding="clientName@networkDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK1@networkDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY1@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK1@networkDetailsBean@servletRequest"
                          textBinding="customKey1@networkDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK2@networkDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY2@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK2@networkDetailsBean@servletRequest"
                          textBinding="customKey2@networkDetailsBean@servletRequest" 
                          styleClass="OraDataText" /> 
                        <uix:styledText 
                          renderedBinding="showCK3@networkDetailsBean@servletRequest"
                          textBinding="CSA_CUSTOMKEY3@CSAResourceBundle" 
                          styleClass="OraPromptText" /> 
                        <uix:styledText 
                          renderedBinding="showCK3@networkDetailsBean@servletRequest"
                          textBinding="customKey3@networkDetailsBean@servletRequest" 
                          styleClass="OraDataText" />
                        <uix:styledText
                          textBinding="LBL_APPLICATIONID@CSAResourceBundle"
                          styleClass="OraPromptText" />
                        <uix:styledText
                          textBinding="appID@networkDetailsBean@servletRequest"
                          styleClass="OraDataText" />
                      </uix:contents>
                    </uix:labeledFieldLayout>

                  </uix:contents>
                </uix:rowLayout>

                <uix:tableLayout hAlign="center">
                  <uix:contents>

                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>

                            <uix:link id="NETWORK"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat columnSpan="3">
                                  <uix:contents>
                                    <uix:header textBinding="HDR_NETWORK@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                            
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_IPADDR@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="ipAddress@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_EFFECTIVE_IPADDR@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="effIPAddress@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_CONNECTIONTYPE@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="connectionType@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>


                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_LATENCY@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="latency@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                             <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_BANDWIDTH@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="bandwidth@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                                     
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_SUBNET@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="subnet@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:link id="BROWSER"/>
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat columnSpan="3">
                                  <uix:contents>
                                    <uix:header textBinding="HDR_BROWSER@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSER@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browser@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_JVM@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="jvm@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_AUTO_CONFIG_URL@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="autoConfigURL@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_BROWSER_PROXY_ENABLED@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browserProxyEnabled@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>


                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_PROXY@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="proxy@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSERPROXYEX@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browserProxyExceptions@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSERCACHESIZE@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browserCacheSize@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSERCACHEUPDATE@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browserCacheUpdateFrequency@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_BROWSERHTTPSUPPORT@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="browserHTTP11Support@networkDetailsBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>


                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:tableLayout>

              </uix:contents>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
