<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="osGeneralBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.OSGeneralBean"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>


  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
   	<%@ include file="/oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>

        <uix:stackLayout>
          <uix:contents>
            <uix:breadCrumbs>
              <uix:contents>
                <uix:link textBinding="breadText@osGeneralBean@servletRequest"
                          destinationBinding="breadDest@osGeneralBean@servletRequest"/>
                <uix:link textBinding="HC_OS_VIEW_HEADER@HCResourceBundle"/>
              </uix:contents>
            </uix:breadCrumbs>

            <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>


            <uix:header textBinding="HC_OS_VIEW_HEADER@HCResourceBundle">
              <uix:contents>
                <uix:stackLayout>
                <uix:rowLayout hAlign="right" vAlign="bottom">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraTipLabel" textBinding="capturedTime@osGeneralBean@servletRequest"/>
                        <uix:spacer width="8"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>

                <uix:spacer height="20"/>
                
                <uix:tableLayout hAlign="center" width="100%">
                  <uix:contents>
                    
                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>
 
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="20"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                         
                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_CSACLIENT@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="clientName@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                            <uix:rowLayout renderedBinding="showCK1@osGeneralBean@servletRequest">
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY1@CSAResourceBundle" renderedBinding="showCK1@osGeneralBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="customKey1@osGeneralBean@servletRequest" renderedBinding="showCK1@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout renderedBinding="showCK2@osGeneralBean@servletRequest">
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY2@CSAResourceBundle" renderedBinding="showCK2@osGeneralBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                              <uix:styledText styleClass="OraDataText" textBinding="customKey2@osGeneralBean@servletRequest" renderedBinding="showCK2@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                            <uix:rowLayout renderedBinding="showCK3@osGeneralBean@servletRequest">
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY3@CSAResourceBundle" renderedBinding="showCK3@osGeneralBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="customKey3@osGeneralBean@servletRequest" renderedBinding="showCK3@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>  
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_APPID@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="appID@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                          
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                  
                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:spacer width="50"/>
                      </uix:contents>
                    </uix:cellFormat>

                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="20"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="OS_SUMMARY.OS@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="os@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="OS_SUMMARY.OS_VENDOR@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="osVendor@osGeneralBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                
                  </uix:contents>
                </uix:tableLayout>


                <uix:spacer height="10"/>       
                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="0">
                      <uix:contents>
                        <uix:link textBinding="HC_OS_GENERAL_SUBTAB@HCResourceBundle"
                                  destinationBinding="generalDest@osGeneralBean@servletRequest" />
                        <uix:link textBinding="HC_FILE_SYSTEM_SUBTAB@HCResourceBundle"
                                  destinationBinding="fsDest@osGeneralBean@servletRequest" />
                        <uix:link textBinding="HC_PATCHES_NAME@HCResourceBundle"
                                  destinationBinding="patchesDest@osGeneralBean@servletRequest" />                               
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:subTabs>
                  <uix:contents>

                    <uix:spacer height="5"/>
                    <uix:tableLayout hAlign="center">
                      <uix:contents>

                        <uix:cellFormat vAlign="top">
                          <uix:contents>
                            <uix:labeledFieldLayout fieldWidth="0" labelWidth="300" width="0">
                              <uix:contents> 

                                <uix:styledText
                                  renderedBinding="showOsDistributorVersion@osGeneralBean@servletRequest"
                                  textBinding="OS_SUMMARY.OS_DISTRIBUTOR_VERSION@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  renderedBinding="showOsDistributorVersion@osGeneralBean@servletRequest"
                                  textBinding="osDistributorVersion@osGeneralBean@servletRequest"
                                  styleClass="OraDataText" />
                                <uix:styledText
                                  textBinding="OS_SUMMARY.OS_MAX_SWAP_SPACE_IN_MB@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  textBinding="maxSwapSpace@osGeneralBean@servletRequest"
                                  styleClass="OraDataText" />
                                <uix:styledText
                                  textBinding="OS_SUMMARY.OS_MAX_PROCESS_VIRTUAL_MEMORY@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  textBinding="maxVM@osGeneralBean@servletRequest"
                                  styleClass="OraDataText"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:cellFormat>
            
                        
                        <uix:cellFormat vAlign="top">
                          <uix:contents>
                            <uix:labeledFieldLayout fieldWidth="0" labelWidth="300" width="0">
                              <uix:contents>
                              
                                <uix:styledText
                                  textBinding="OS_SUMMARY.OS_TIMEZONE@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  textBinding="timezone@osGeneralBean@servletRequest"
                                  styleClass="OraDataText"/>
                                <uix:styledText
                                  textBinding="OS_SUMMARY.OS_TIMEZONE_REGION@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  textBinding="timezoneRegion@osGeneralBean@servletRequest"
                                  styleClass="OraDataText"/>
                                <uix:styledText
                                  textBinding="OS_SUMMARY.OS_TIMEZONE_DELTA@HCResourceBundle"
                                  styleClass="OraPromptText" />
                                <uix:styledText
                                  textBinding="timezoneDelta@osGeneralBean@servletRequest"
                                  styleClass="OraDataText"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:contents>
                        </uix:cellFormat>

                      </uix:contents>
                    </uix:tableLayout>

<!-- OS Properties table node -->
                    <uix:header textBinding="OS_KERNEL_PARAMS@HCResourceBundle">
                      <uix:contents>
                        <uix:include nodeBinding="propsTable@osGeneralBean@servletRequest"/>
                      </uix:contents>
                    </uix:header>
                  </uix:contents>
                </uix:subTabLayout> 
              </uix:stackLayout>           
              </uix:contents>
            </uix:header>

          </uix:contents>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

