<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<jsp:useBean id="osPatchesBean" scope="request"
             type="oracle.sysman.eml.ecm.csa.OSPatchesBean"/>

        <style TYPE="text/css">
          .fixed{  font-family: Courier, New; font-size: 10pt;}      
        </style>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="HCResourceBundle"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="CSAResourceBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>



  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
   	<%@ include file="/oemTitle.jspf" %>

  	<uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf" %>
  
  
        <uix:stackLayout>
          <uix:contents>
            <uix:breadCrumbs>
              <uix:contents>
                <uix:link textBinding="breadText@osPatchesBean@servletRequest"
                          destinationBinding="breadDest@osPatchesBean@servletRequest"/>
                <uix:link textBinding="HC_OS_VIEW_HEADER@HCResourceBundle"/>
              </uix:contents>
            </uix:breadCrumbs>

            <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>


            <uix:header textBinding="HC_OS_VIEW_HEADER@HCResourceBundle">
              <uix:contents>
                <uix:rowLayout hAlign="right" vAlign="bottom">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                        <uix:styledText styleClass="OraTipText" textBinding="CSA_COLLECTION_TIMESTAMP@CSAResourceBundle"/>
                        <uix:spacer width="5"/>
                        <uix:styledText styleClass="OraTipLabel" textBinding="capturedTime@osPatchesBean@servletRequest"/>
                        <uix:spacer width="8"/>
                      </uix:contents>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>

                <uix:spacer height="20"/>

                <uix:tableLayout hAlign="center" width="100%">
                  <uix:contents>
                    
                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>
 
                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="20"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>
                         
                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="LBL_CSACLIENT@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="clientName@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY1@CSAResourceBundle" renderedBinding="showCK1@osPatchesBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="customKey1@osPatchesBean@servletRequest" renderedBinding="showCK1@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY2@CSAResourceBundle" renderedBinding="showCK2@osPatchesBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                              <uix:styledText styleClass="OraDataText" textBinding="customKey2@osPatchesBean@servletRequest" renderedBinding="showCK2@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_CUSTOMKEY3@CSAResourceBundle" renderedBinding="showCK3@osPatchesBean@servletRequest"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="customKey3@osPatchesBean@servletRequest" renderedBinding="showCK3@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>  
                                    <uix:styledText styleClass="OraPromptText" textBinding="CSA_APPID@CSAResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="appID@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                          
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                  
                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:spacer width="50"/>
                      </uix:contents>
                    </uix:cellFormat>

                    <uix:cellFormat vAlign="top">
                      <uix:contents>
                        <uix:tableLayout>
                          <uix:contents>

                            <uix:rowLayout>
                              <uix:contents>
                                <uix:cellFormat hAlign="right">
                                  <uix:contents>
                                    <uix:spacer height="20"/>
                                  </uix:contents>
                                </uix:cellFormat>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="OS_SUMMARY.OS@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="os@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>

                            <uix:rowLayout>
                              <uix:contents> 
                                <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                  <uix:contents>
                                    <uix:styledText styleClass="OraPromptText" textBinding="OS_SUMMARY.OS_VENDOR@HCResourceBundle"/>
                                  </uix:contents>
                                </uix:cellFormat>
                                <uix:spacer width="10"/>
                                <uix:styledText styleClass="OraDataText" textBinding="osVendor@osPatchesBean@servletRequest"/>
                              </uix:contents>
                            </uix:rowLayout>
                          
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:cellFormat>
                
                  </uix:contents>
                </uix:tableLayout>



                       
                <uix:subTabLayout>
                  <uix:subTabs>
                    <uix:subTabBar selectedIndex="2">
                      <uix:contents>
                        <uix:link textBinding="HC_OS_GENERAL_SUBTAB@HCResourceBundle"
                                  destinationBinding="generalDest@osPatchesBean@servletRequest" />
                        <uix:link textBinding="HC_FILE_SYSTEM_SUBTAB@HCResourceBundle"
                                  destinationBinding="fsDest@osPatchesBean@servletRequest" />
                        <uix:link textBinding="HC_PATCHES_NAME@HCResourceBundle"
                                  destinationBinding="patchesDest@osPatchesBean@servletRequest" />                               
                      </uix:contents>
                    </uix:subTabBar>
                  </uix:subTabs>
                  <uix:contents>
                                                                 
<!-- Patches table node -->
                    <uix:tableLayout width="100%">
                      <uix:contents>
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:rawText textBinding="patchesText@osPatchesBean@servletRequest"/>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:tableLayout>
                    <uix:spacer height="10"/>
                  </uix:contents>
                </uix:subTabLayout> 
                         
              </uix:contents>
            </uix:header>

          </uix:contents>
        </uix:stackLayout>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>

  