
<%-- readCookies.jsp: CSA Cookie Test --%>

<%@ page language="java" contentType="text/html" %>

<%@ page import = "java.io.*" %>
<%@ page import = "java.net.*" %>
<%@ page import = "java.util.Date" %>
<%@ page import = "java.text.SimpleDateFormat" %>

<html>
<head><title>Read-only CSA Cookie Test</title></head>
<body>
<%
  // TBD???: Specify no caching of JSP page ...
  response.setHeader("Pragma", "No-cache");
  response.setHeader("Cache-Control", "no-cache");
  response.setDateHeader("Expires", 1);


  String   cookieName = "ORA_SMP_CSA";  // Oracle EM Client System Analyzer
  String   cookieValue = "";
  Cookie[] cookies  = request.getCookies();
  Cookie   aCookie    = null;
  int      nCookies = ((cookies == null) ? 0 : cookies.length);
  int      ii;
  int      csaCookieCnt = 0;
  int      idx          = 0;

  long    currTS    = System.currentTimeMillis();
  long    prevTS    = 0;           // for an existing cookie, if any
  long    cookieAge = 0;           // diff between prevTS and currTS (in msec)



  // Does a CSA cookie already exist?...
  for (ii = 0; ii < nCookies; ii++)
  {
    aCookie = cookies[ii];
    if (aCookie.getName().equals(cookieName))
    {
      cookieValue = aCookie.getValue();

      if ((idx = cookieValue.indexOf("[")) > 0)
      {
        try
        {
          prevTS = Long.parseLong(cookieValue.substring(0,idx));
          cookieAge = currTS - prevTS;
%>
<P> Found CSA cookie <%= cookieValue %>, with age = <%= cookieAge %> msec </P>
<%
        }
        catch (Exception e)
        {
%>
<P> Found CSA cookie <%= cookieValue %>, but exception finding its age </P>
<%
        }
      }
      else
      {
%>
<P> Found CSA cookie <%= cookieValue %>, but cannot determine its age </P>
<%
      }
      csaCookieCnt++;
    }
  }

  // If client config cookie was found ...
  if (csaCookieCnt > 0)
  {
%>
<P> Total of <%= csaCookieCnt %> CSA cookie(s) found </P>
<%
  }
  else
  {
%>
<P> Found no CSA cookies </P>
<%
  }
%>

</body>
</html>

