<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.csa.CSAConsts" %>
<%@ page import="oracle.sysman.eml.ecm.spf.SearchPageConstants" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="searchBundle"
    class="oracle.sysman.eml.ecm.search.util.SearchResourceBundle" />
  <uix:bundle name="csaBundle"
              class="oracle.sysman.eml.ecm.csa.CSAResourceBundle"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <uix:body>

    <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="post">


          <uix:pageLayout titleBinding="TITLE_CSACONFIG@csaBundle">
           

          <%@ include file="/oemGlobal.jspf" %>
          <uix:stackLayout>
            <uix:contents>
              <uix:rowLayout hAlign="right">
                <oem:pageRefreshed/>
                  <uix:submitButton 
                              textBinding="BTN_SQLSEARCH@csaBundle"
                              name="event"
                              value="sqlSearch"
                              formNameBinding="eml_ecm_sc_formName@servletRequest"/>
              </uix:rowLayout>
              <uix:spacer height="20"/>
              <uix:styledText styleClass="OraInstructionText" 
                              textBinding="INSTR_CSACLIENT@csaBundle" /> 
            </uix:contents>
          </uix:stackLayout>
          
          <uix:spacer height="20"/>



          <oem:messageBox messageType="error"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="errors@servletRequest"/>

          <oem:messageBox messageType="warning"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="warnings@servletRequest"/>

          <oem:messageBox messageType="info"
              titleTextKey="titleText" mainTextKey="mainText"
              errorTableBinding="rowMsg@servletRequest"/>


<uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>

              <uix:stackLayout>
                <uix:contents>
              <uix:rowLayout hAlign="left">
                <uix:contents>
                  <uix:styledText styleClass="OraPromptText" textBinding="LBL_TOTALCLIENTS@csaBundle"/>
                  <uix:spacer width="5"/>
                  <uix:styledText styleClass="OraDataText" textBinding="numCollections@servletRequest"/>
                </uix:contents>
              </uix:rowLayout>
              </uix:contents>
              </uix:stackLayout>
              <uix:spacer height="20"/>


<%--              
              <uix:stackLayout>
                <uix:spacer width="10"/>
                <uix:separator/>
                    <uix:tableLayout width="100%">
                      <uix:styledText styleClass="OraInlineInfoText" textBinding="sqlStatement@searchCSAJspBean@servletRequest"/>
                    </uix:tableLayout>
              </uix:stackLayout>
--%>          
              <uix:switcher childNameBinding="tabChoice@servletRequest">
                <uix:case name="results">

                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:subTabBar selectedIndex="0">
                        <uix:contents>
                          <uix:link textBinding="LBL_CSA_RESULT@csaBundle"
                                    destinationBinding="resultsDest@servletRequest" />
                          <uix:link textBinding="LBL_CSA_SUMMARY@csaBundle"
                                    destinationBinding="summaryDest@servletRequest" />
                          <uix:link textBinding="LBL_CSA_COMPLIANCE@csaBundle"
                                    destinationBinding="complianceDest@servletRequest" />
                        </uix:contents>
                      </uix:subTabBar>
                    </uix:subTabs>
                    <uix:contents>
                      <uix:spacer height="10"/> 
                      <uix:dataScope currentDataBinding="searchCSAJspBean@servletRequest"> 
                        <uix:table name="clientList" 
                                   id="clientListID"
                                   showAll="yes"
                                   partialRenderMode="self"
                                   alternateTextBinding="NO_DATA@csaBundle"
                                   formSubmitted="true"
                                   width="100%"
                                   minValue="1"
                                   tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                   valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                   maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                   blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                   summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
               
                          <uix:tableFormat tableBanding="rowBanding"/>
                          
                          <uix:tableSelection>
                            <uix:multipleSelection shortDescBinding="MULTISEL_RESULTSTABLE@csaBundle">
                              <uix:contents>
                                <uix:submitButton name="event" value="deleteConfirm" textBinding="BTN_DELETE@csaBundle"/>
                              </uix:contents>
                            </uix:multipleSelection>
                          </uix:tableSelection>
  
                          <%-- Client column --%>
                          <uix:column> 
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_CSACLIENT@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_CLIENT %>" />
                            </uix:columnHeader> 
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= CSAConsts.S_LBL_CLIENT %>"
                                      destinationBinding="<%= CSAConsts.S_DEST_CLIENT %>" />
                          </uix:column>
                          
                          <%-- Application ID column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_APPLICATIONID@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPID %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= CSAConsts.S_LBL_APPID %>"
                                      destinationBinding="<%= CSAConsts.S_DEST_APPID %>" />
                          </uix:column>
                
                          <%-- Overall Compliance column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_OVERALLCOMPLIANCE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OVERALLCOMPLIANCE %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                            <uix:include nodeBinding="<%= CSAConsts.S_LBL_OVERALLCOMPLIANCE_IMAGE %>" />
                          </uix:column>
                
                          <%--IP address column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_IPADDR@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_IPADDRESS %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_IPADDRESS %>" />
                          </uix:column>
  
                          <%--Timestamp column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_COLLECTDATE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_COLLECTED %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_COLLECTED %>" />
                          </uix:column>
    
                          <%--OS column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_OS@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_OPERATINGSYSTEM %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_OPERATINGSYSTEM %>" />
                          </uix:column>
  
                          <%--Hardware column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_HARDWARE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_HARDWARE %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_HARDWARE %>" />
                          </uix:column>

                          <%--Browser column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_BROWSER@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_BROWSER %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_BROWSER %>" />
                          </uix:column>

  
                          <%--Latency column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_LATENCY@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_LATENCY %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="numberFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_LATENCY %>" />
                          </uix:column>
  
                          <%--Bandwidth column --%>
                          <uix:column>
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_BANDWIDTH@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_BANDWIDTH %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="numberFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_BANDWIDTH_DISPLAY %>" />
                          </uix:column>

                          <%-- CSA Collector column --%>
                          <uix:column renderedBinding="advancedMode@servletRequest"> 
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_CSACOLLECTOR@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_CSACOLLECTOR %>" />
                              </uix:columnHeader> 
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= CSAConsts.S_LBL_CSACOLLECTOR %>"
                                      destinationBinding="<%= CSAConsts.S_DEST_CSACOLLECTOR %>" />
                          </uix:column>
  
                          <%--DESTINATION URL column --%>
                          <uix:column renderedBinding="advancedMode@servletRequest">
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_DESTURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_DESTINATIONURL %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>"
                                      destinationBinding="<%= CSAConsts.S_LBL_DESTINATIONURL %>" />
                          </uix:column>
  
                          <%--APPLET URL column --%>
                          <uix:column renderedBinding="advancedMode@servletRequest">
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_CSAAPPURL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_APPLETURL %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:link textBinding="<%= CSAConsts.S_LBL_APPLETURL %>"
                                      destinationBinding="<%= CSAConsts.S_LBL_APPLETURL %>" />
                          </uix:column>
  
                          <%--Proxy Server column --%>
                          <uix:column renderedBinding="advancedMode@servletRequest">
                            <uix:columnHeader>
                              <uix:sortableHeader textBinding="LBL_PROXYSERVER@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_PROXYSERVER %>" />
                            </uix:columnHeader>
                            <uix:columnFormat columnDataFormat="textFormat"/>
                            <uix:styledText textBinding="<%= CSAConsts.S_LBL_PROXYSERVER %>" />
                          </uix:column>
                
                
                
                        </uix:table >
                      </uix:dataScope>              
                      <uix:spacer height="10"/> 
                    </uix:contents>
                  </uix:subTabLayout>
 
                  
                </uix:case>
                <uix:case name="summary">
                  <uix:subTabLayout>
                    <uix:subTabs>
                      <uix:subTabBar selectedIndex="1">
                        <uix:contents>
                            <uix:link textBinding="LBL_CSA_RESULT@csaBundle"
                                      destinationBinding="resultsDest@servletRequest" />
                            <uix:link textBinding="LBL_CSA_SUMMARY@csaBundle"
                                      destinationBinding="summaryDest@servletRequest" />
                            <uix:link textBinding="LBL_CSA_COMPLIANCE@csaBundle"
                                      destinationBinding="complianceDest@servletRequest" />
                        </uix:contents>
                      </uix:subTabBar>
                    </uix:subTabs>
                    <uix:contents>
                      <uix:spacer height="10"/> 
                      <%--<uix:stackLayout>--%>
                      <uix:tableLayout>
                        <uix:contents>
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                              <uix:tableLayout>
                                <uix:contents>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:header textBinding="LBL_BROWSER@csaBundle">
                                        <uix:contents>
                                          <oem:chart chartType="pieChart"
                                                     width="180"
                                                     height="160"
                                                     shortDescBinding="shortDesc@browserPieChart@servletRequest"
                                                     pieValuesInLegend="value"
                                                     showSlicePercentLabels="true"
                                                     pieSliceColorsBinding="pieChartColors@browserPieChart@servletRequest"
                                                     backgroundColorBinding="backgroundColor@browserPieChart@serveltRequest"
                                                     hideZeroSlices="true"
                                                     legendVisible="external">
                                            <oem:boundChartDataSource chartDataSourceBinding="pieChartData@browserPieChart@servletRequest" />
                                            <oem:imageMap imageMapItemsBinding="pieChartImageMap@browserPieChart@servletRequest"/>
                                            <oem:chartColumn isKey="true"
                                                             displayLabel="Browser"
                                                             sourceIndex="0"/>
                                            <oem:chartColumn displayLabel="Cients"
                                                             sourceIndex="1"/>
                                          </oem:chart>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:rowLayout>

                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:header textBinding="LBL_OS@csaBundle">
                                        <uix:contents>
                                          <oem:chart chartType="pieChart"
                                                     width="180"
                                                     height="160"
                                                     shortDescBinding="shortDesc@osPieChart@servletRequest"
                                                     pieValuesInLegend="value"
                                                     showSlicePercentLabels="true"
                                                     pieSliceColorsBinding="pieChartColors@osPieChart@servletRequest"
                                                     backgroundColorBinding="backgroundColor@osPieChart@serveltRequest"
                                                     hideZeroSlices="true"
                                                     legendVisible="external">
                                            <oem:boundChartDataSource chartDataSourceBinding="pieChartData@osPieChart@servletRequest" />
                                            <oem:imageMap imageMapItemsBinding="pieChartImageMap@osPieChart@servletRequest"/>
                                            <oem:chartColumn isKey="true"
                                                             displayLabel="OS"
                                                             sourceIndex="0"/>
                                            <oem:chartColumn displayLabel="Cients"
                                                             sourceIndex="1"/>
                                          </oem:chart>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:tableLayout>
                            </uix:contents>
                          </uix:cellFormat>
                          
                          
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                              <uix:spacer width="10"/>
                            </uix:contents>
                          </uix:cellFormat>
                          
                          <uix:cellFormat vAlign="top">
                            <uix:contents>
                              <uix:tableLayout>
                                <uix:contents>
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:header textBinding="LBL_TOTALMEMORY@csaBundle">
                                        <uix:contents>
                                          <oem:chart chartType="pieChart"
                                                     width="180"
                                                     height="160"
                                                     shortDescBinding="shortDesc@ramPieChart@servletRequest"
                                                     pieValuesInLegend="value"
                                                     showSlicePercentLabels="true"
                                                    pieSliceColorsBinding="pieChartColors@ramPieChart@servletRequest"
                                                     backgroundColorBinding="backgroundColor@ramPieChart@serveltRequest"
                                                     hideZeroSlices="true"
                                                     legendVisible="external">
                                            <oem:boundChartDataSource chartDataSourceBinding="pieChartData@ramPieChart@servletRequest" />
                                            <oem:imageMap imageMapItemsBinding="pieChartImageMap@ramPieChart@servletRequest"/>
                                            <oem:chartColumn isKey="true"
                                                             displayLabel="RAM"
                                                             sourceIndex="0"/>
                                            <oem:chartColumn displayLabel="Cients"
                                                             sourceIndex="1"/>
                                          </oem:chart>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:rowLayout>
                          
                                  <uix:rowLayout>
                                    <uix:contents>
                                      <uix:header textBinding="LBL_CPU@csaBundle">
                                        <uix:contents>
                                          <oem:chart chartType="pieChart"
                                                     width="180"
                                                     height="160"
                                                     shortDescBinding="shortDesc@cpuPieChart@servletRequest"
                                                     pieValuesInLegend="value"
                                                     showSlicePercentLabels="true"
                                                     pieSliceColorsBinding="pieChartColors@cpuPieChart@servletRequest"
                                                     backgroundColorBinding="backgroundColor@cpuPieChart@serveltRequest"
                                                     hideZeroSlices="true"
                                                     legendVisible="external">
                                            <oem:boundChartDataSource chartDataSourceBinding="pieChartData@cpuPieChart@servletRequest" />
                                            <oem:imageMap imageMapItemsBinding="pieChartImageMap@cpuPieChart@servletRequest"/>
                                            <oem:chartColumn isKey="true"
                                                             displayLabel="CPU"
                                                             sourceIndex="0"/>
                                            <oem:chartColumn displayLabel="Cients"
                                                             sourceIndex="1"/>
                                          </oem:chart>
                                        </uix:contents>
                                      </uix:header>
                                    </uix:contents>
                                  </uix:rowLayout>
                                </uix:contents>
                              </uix:tableLayout>
                            </uix:contents>
                          </uix:cellFormat>
                        </uix:contents>
                      </uix:tableLayout>

                      <uix:spacer height="10"/> 
                    </uix:contents>
                  </uix:subTabLayout>
                </uix:case>
                <uix:case name="comp">

                    <uix:subTabLayout>
                      <uix:subTabs>
                        <uix:subTabBar selectedIndex="2">
                          <uix:contents>
                              <uix:link textBinding="LBL_CSA_RESULT@csaBundle"
                                        destinationBinding="resultsDest@servletRequest" />
                              <uix:link textBinding="LBL_CSA_SUMMARY@csaBundle"
                                        destinationBinding="summaryDest@servletRequest" />
                              <uix:link textBinding="LBL_CSA_COMPLIANCE@csaBundle"
                                        destinationBinding="complianceDest@servletRequest" />
                          </uix:contents>
                        </uix:subTabBar>
                      </uix:subTabs>
                      <uix:contents>
                        <uix:spacer height="10"/> 
                          <uix:stackLayout>
                            <uix:contents>
                              <uix:rowLayout>
                                <uix:contents>
                                  <uix:header textBinding="LBL_OVERALLCOMPLIANCE@csaBundle">
                                    <uix:contents>
                                      <oem:chart chartType="pieChart"
                                                 width="360"
                                                 height="160"
                                                 shortDescBinding="shortDesc@compliancePieChart@servletRequest"
                                                 pieValuesInLegend="value"
                                                 showSlicePercentLabels="true"
                                                 pieSliceColorsBinding="pieChartColors@compliancePieChart@servletRequest"
                                                 backgroundColorBinding="backgroundColor@compliancePieChart@serveltRequest"
                                                 hideZeroSlices="true"
                                                 legendVisible="external">
                                        <oem:boundChartDataSource chartDataSourceBinding="pieChartData@compliancePieChart@servletRequest" />
                                        <oem:imageMap imageMapItemsBinding="pieChartImageMap@compliancePieChart@servletRequest"/>
                                        <oem:chartColumn isKey="true"
                                                         displayLabel="Compliance"
                                                         sourceIndex="0"/>
                                        <oem:chartColumn displayLabel="Cients"
                                                         sourceIndex="1"/>
                                      </oem:chart>
                                    </uix:contents>
                                  </uix:header>                                  
                                </uix:contents>
                              </uix:rowLayout>

                              <uix:header textBinding="COMP_BY_RULE_HDR@csaBundle">
                                <uix:contents>
                                  <uix:dataScope currentDataBinding="searchCSARulesBean@servletRequest"> 
                                    <uix:table name="compList" 
                                             id="compListID"
                                             partialRenderMode="self"
                                             alternateTextBinding="MSG_PRESSSEARCH@csaBundle"
                                             formSubmitted="true"
                                             width="100%"
                                             minValue="1"
                                             showAll="yes"
                                             tableDataBinding="<%= UIXDataSource.S_ROW_DATA_ATTR %>"
                                             valueBinding="<%= UIXDataSource.S_START_INDEX_ATTR %>"
                                             maxValueBinding="<%= UIXDataSource.S_NUM_ROWS_ATTR %>"
                                             blockSizeBinding="<%= UIXDataSource.S_BLOCK_SIZE_ATTR %>"
                                             summaryBinding="TBLSUM_RESULTSTABLE@csaBundle">
                         
                                    <uix:tableFormat tableBanding="rowBanding"/>
          
                                    <%-- Rule column --%>
                                    <uix:column> 
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="LBL_RULE@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_RULE %>" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="textFormat"/>
                                      <uix:styledText textBinding="<%= CSAConsts.S_LBL_RULE %>" />
                                    </uix:column>
          
                                    <%-- Totals column --%>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="TOTAL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_TOTAL %>" />
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                                      <uix:rowLayout hAlign="left">
                                        <uix:contents>
                                          <uix:include nodeBinding="<%= CSAConsts.S_LBL_CIGAR %>" />
                                          <uix:spacer width="5"/>
                                          <uix:link textBinding="<%= CSAConsts.S_LBL_TOTAL %>" 
                                                destinationBinding="<%= CSAConsts.S_DEST_TOTAL %>" />    
                                        </uix:contents>
                                      </uix:rowLayout>
                                    </uix:column>
          
                                    <%-- Critical column --%>
                                    <uix:column> 
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="OP_CRITICAL@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_CRITICAL %>" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                      <uix:link textBinding="<%= CSAConsts.S_LBL_CRITICAL %>"
                                                destinationBinding="<%= CSAConsts.S_DEST_CRITICAL %>" />
                                    </uix:column>
          
                                    <%-- Warning column --%>
                                    <uix:column> 
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="OP_WARNING@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_WARNING %>" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                      <uix:link textBinding="<%= CSAConsts.S_LBL_WARNING %>"
                                                destinationBinding="<%= CSAConsts.S_DEST_WARNING %>" />
                                    </uix:column>
          
                                    <%-- Info column --%>
                                    <uix:column> 
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="OP_INFO@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_INFO %>" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                      <uix:link textBinding="<%= CSAConsts.S_LBL_INFO %>"
                                                destinationBinding="<%= CSAConsts.S_DEST_INFO %>" />
                                    </uix:column>
          
                                    <%-- Passed column --%>
                                    <uix:column> 
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="OP_PASSED@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_PASSED %>" />
                                      </uix:columnHeader> 
                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                      <uix:link textBinding="<%= CSAConsts.S_LBL_PASSED %>"
                                                destinationBinding="<%= CSAConsts.S_DEST_PASSED %>" />
                                    </uix:column>
          
                                    <%-- NA column --%>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:sortableHeader textBinding="OP_NA@csaBundle" sortableBinding="<%= CSAConsts.S_SORT_NA %>" />
                                      </uix:columnHeader>
                                      <uix:columnFormat columnDataFormat="numberFormat"/>
                                      <uix:link textBinding="<%= CSAConsts.S_LBL_NA %>"
                                                destinationBinding="<%= CSAConsts.S_DEST_NA %>" />
                                    </uix:column>
          
                                  </uix:table >
                                  <uix:rowLayout hAlign="left" >
                                    <uix:include nodeBinding="<%= CSAConsts.S_LBL_CIGAR_LEGEND %>" />
                                  </uix:rowLayout>
                                </uix:dataScope>              
                              </uix:contents>
                            </uix:header>
                          </uix:contents>
                        </uix:stackLayout>
                        
                        <uix:spacer height="30"/> 
                      </uix:contents>
                    </uix:subTabLayout>
                </uix:case>
                
                
              </uix:switcher>
        </uix:pageLayout>
   
    </uix:form>

   </uix:body>
  </uix:document>
</uix:renderingContext>
<%------------------------------  End of File  -------------------------------%>
