<%--
  -- Page:        ecmErrorPage.jsp
  -- Controller:  oracle.sysman.eml.ecm.policy.EcmErrorPageController
  --
  -- Description: Displayed when error occurs during processing page
  --
  --  MODIFIED    (MM/DD/YY)
  --   kchiasso    03/14/05 - kchiasso_ecmerrorpage
  --   kchiasso    11/03/05 - Creation
--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:renderingContext id="renderingContext">
    <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="msgBundle" 
                class="oracle.sysman.eml.ecm.util.EcmResourceBundle"/>
    <uix:document>
      <%@ include file="/oemTitle.jspf"%>
   
     <uix:body>
     <uix:form name="ecmErrorPage" method="GET" destination="/em/console/ecm/ecmErrorPage">

        <uix:pageLayout>
    
        <%@ include file="/oemGlobal.jspf"%>

            <uix:stackLayout>
              <uix:header iconBinding="msgIcon@ecmErrorPageJspBean@servletRequest" 
                          textBinding="msgHdr@ecmErrorPageJspBean@servletRequest">

                <uix:contents>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="msgText@ecmErrorPageJspBean@servletRequest" 
                                    styleClass="OraInstructionTextStrong"/>
                  </uix:rowLayout>
                  <uix:spacer height="10"/>
                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                    <uix:styledText textBinding="msgInst@ecmErrorPageJspBean@servletRequest" styleClass="OraInstructionText"/>
                  </uix:rowLayout>
                </uix:contents>

              </uix:header>
            </uix:stackLayout>
          
          <%-------------------------
           -  Page Buttons
           ---------------------------%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="ECM_OK@msgBundle" 
                                name="event" value="return"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
            
            
        
        </uix:pageLayout>

     </uix:form>
     </uix:body>
    </uix:document>
</uix:renderingContext>
