<%--
  -- Page:        compMultiRow.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.CompMultiPageSegController
  -- Bean:        oracle.sysman.eml.ecm.generic.CompMultiPageSegBean
  --
  -- Description: This page segment displays the diff of two ECM
  --              multi-row tables
  --
  --  MODIFIED    (MM/DD/YY)
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     jochen    08/10/05 - Add label to dropdown 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    05/02/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.JspConstants" %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.eml.ecm.generic.CompMultiPageSegBean' %>
<%@ page import='oracle.sysman.eml.ecm.generic.CompMultiTableDataSource' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>
  <%-- Message bundles --%>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%
    PageSegmentContext psc =
            (PageSegmentContext)request.getAttribute("pageSegmentContext");
    CompMultiPageSegBean segBean =
            (CompMultiPageSegBean)psc.getPageSegmentBean();
    out.println("DisplapName in MultiROW is :" + segBean.getTableDisplayName());       
  %>
  <uix:link id="<%= segBean.getTableDisplayName() %>"/>
   
   <uix:header textBinding="<%= segBean.getFullTableNameAttr() %>"
              iconBinding="resultIcon@pageSegmentBean@">
          
    <uix:tableLayout width="100%">

      <uix:rowLayout width="100%">

        <uix:cellFormat hAlign="right" vAlign="bottom">
          <uix:rowLayout>
            <%--                   --%>
            <%-- Show Diffs or All --%>
            <%--                   --%>
            <uix:messageChoice name="<%= segBean.getUIXChoiceID() %>"
                               promptBinding="VIEW@sdkMsgs"
                               selectedIndexBinding="selectAllDiff@pageSegmentBean@"
                               primaryClientActionBinding="PPRAction@pageSegmentBean@">
              <uix:contents>
                <uix:option textBinding="SHOW_DIFFS@msgs"/>
                <uix:option textBinding="SHOW_ALL@msgs"/>
              </uix:contents>
            </uix:messageChoice>

            <uix:spacer width="7"/>

            <%--             --%>
            <%-- Link to top --%>
            <%--             --%>
            <uix:image source="/em/images/carrue.gif"
                       shortDescBinding="TOP_TIP@msgs"
                       destinationBinding="topLink@pageSegmentBean@"/>
            <uix:spacer width="2"/>
            <uix:link textBinding="RETURN_TOP@msgs"
                      destinationBinding="topLink@pageSegmentBean@"/>

          </uix:rowLayout>
        </uix:cellFormat>
      </uix:rowLayout>

      <%--              --%>
      <%-- Errors       --%>
      <%--              --%>
      <%-- This is only shown if there was an error creating the  --%>
      <%-- display node.  The error is logged and an inline error --%>
      <%-- message is displayed on the page so other segments     --%>
      <%-- can still be rendered                                  --%>
      <uix:rowLayout>
        <uix:styledText id="<%= segBean.getUIXErrorID() %>"
                        textBinding="<%= JspConstants.ERROR %>"
                        styleClass="OraInlineErrorText"/>
      </uix:rowLayout>
      
      <%--       --%>
      <%-- Table --%>
      <%--       --%>
      <uix:rowLayout>
        <uix:ref refID="<%= segBean.getSegID() %>" />
      </uix:rowLayout>

    </uix:tableLayout>
  </uix:header>
</uix:dataScope>
</oem:pageSegment>
