<%--
  -- Page:        compSingleRow.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.CompSinglePageSegController
  -- Bean:        oracle.sysman.eml.ecm.generic.CompSinglePageSegBean
  --
  -- Description: This page segment displays the diff of two ECM
  --              single-row tables
  --
  --  MODIFIED    (MM/DD/YY)
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     lappanmu  11/29/05 - Generic UI changes 
  --     jochen    08/08/05 - Change no data to no diffs - add label to choice
  --     jochen    08/01/05 - jochen_view1
  --     jochen    04/21/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.JspConstants" %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.eml.ecm.generic.CompSinglePageSegBean' %>
<%@ page import='oracle.sysman.eml.ecm.generic.CompSingleTableDataSource' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>

  <%-- Message bundles --%>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="sdkMsgs"
                class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <%
    PageSegmentContext psc =
            (PageSegmentContext)request.getAttribute("pageSegmentContext");
    CompSinglePageSegBean segBean =
            (CompSinglePageSegBean)psc.getPageSegmentBean();
  %>

  <%--                      --%>
  <%-- Anchor for quicklink --%>
  <%--                      --%>
  <uix:link id="<%= segBean.getTableDisplayName() %>"/>

  <uix:header textBinding="<%= segBean.getFullTableHeaderAttr() %>"
              iconBinding="resultIcon@pageSegmentBean@">

    <uix:rowLayout width="100%">
      <%--                      --%>
      <%-- Keys for detail mode --%>
      <%--                      --%>
      <uix:cellFormat hAlign="left">
        <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
          <uix:contents childDataBinding="keyData@pageSegmentBean@">
            <uix:styledText textBinding="<%= JspConstants.LABEL %>"
                            styleClass="OraFieldText"/>
            <uix:styledText textBinding="<%= JspConstants.VALUE %>"
                            styleClass="OraDataText"/>
          </uix:contents>
        </uix:labeledFieldLayout>
      </uix:cellFormat>
      <uix:cellFormat hAlign="right" vAlign="bottom">
        <uix:rowLayout>

          <%--                   --%>
          <%-- Show Diffs or All --%>
          <%--                   --%>
          <uix:messageChoice name="<%= segBean.getUIXChoiceID() %>"
                             promptBinding="VIEW@sdkMsgs"
                             selectedIndexBinding="selectAllDiff@pageSegmentBean@"
                             primaryClientActionBinding="PPRAction@pageSegmentBean@">
            <uix:contents>
              <uix:option textBinding="SHOW_DIFFS@msgs"/>
              <uix:option textBinding="SHOW_ALL@msgs"/>
            </uix:contents>
          </uix:messageChoice>

          <%--             --%>
          <%-- Link to top --%>
          <%--             --%>
          <uix:rowLayout renderedBinding="showTopLink@pageSegmentBean@">
            <uix:spacer width="7"/>

            <uix:image source="/em/images/carrue.gif"
                       shortDescBinding="TOP_TIP@msgs"
                       destinationBinding="topLink@pageSegmentBean@"/>
            <uix:spacer width="2"/>
            <uix:link textBinding="RETURN_TOP@msgs"
                      destinationBinding="topLink@pageSegmentBean@"/>
          </uix:rowLayout>

        </uix:rowLayout>
      </uix:cellFormat>
    </uix:rowLayout>

    <%--              --%>
    <%-- Errors       --%>
    <%--              --%>
    <%-- This is only shown if there was an error creating the  --%>
    <%-- display node.  The error is logged and an inline error --%>
    <%-- message is displayed on the page so other segments     --%>
    <%-- can still be rendered                                  --%>
    <uix:rowLayout>
      <uix:styledText id="<%= segBean.getUIXErrorID() %>"
                      textBinding="<%= JspConstants.ERROR %>"
                      styleClass="OraInlineErrorText"/>
    </uix:rowLayout>

    <%--       --%>
    <%-- Table --%>
    <%--       --%>
    
                     
    <uix:rowLayout width="100%">
      <uix:table id="<%= segBean.getUIXTableID() %>"
                 summaryBinding="tableSummary@pageSegmentBean@"
                 width="100%"
                 alternateTextBinding="NO_DIFFS@msgs"
                 blockSize="<%= CompSingleTableDataSource.S_BLOCK_SIZE %>"
                 minValue="1"
                 tableDataBinding="rowData@tableDataSource@"
                 partialRenderMode="multiple"
                 partialTargets="<%= segBean.getUIXErrorID() %>"
                 showAll="yes"
                 valueBinding="startIndex@tableDataSource@"
                 maxValueBinding="numRows@tableDataSource@">
        <uix:tableFormat tableBanding="rowBanding"/>

        <%-- Result column --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader sortableBinding="result_ecm_sort@tableDataSource@"
                                textBinding="RESULT_COL@msgs"/>
          </uix:columnHeader>
          <uix:columnFormat columnDataFormat="iconButtonFormat"/>
          <uix:contents>
            <uix:image sourceBinding="result_ecm_col"
                       shortDescBinding="resultDesc_ecm_col"
                       destinationBinding="resultDest_ecm_col"/>
          </uix:contents>
        </uix:column>

        <%-- Attribute column --%>
        <uix:column>
          <uix:columnHeader>
            <uix:sortableHeader sortableBinding="attr_ecm_sort@tableDataSource@"
                                textBinding="ATTR_COL@msgs"/>
          </uix:columnHeader>
          <uix:columnFormat columnDataFormat="textFormat"/>
          <uix:contents>
            <uix:styledText textBinding="attr_ecm_col"/>
          </uix:contents>
        </uix:column>

        <%-- Target1 column --%>
        <uix:column columnFormatBinding="dataFormat@pageSegmentBean@">
          <uix:columnHeader>
            <uix:sortableHeader sortableBinding="target1_ecm_sort@tableDataSource@"
                                textBinding="target1Header@pageSegmentBean@" />
          </uix:columnHeader>
          <uix:contents>
            <uix:styledText textBinding="target1_ecm_col"
                            styleClassBinding="<%= CompSingleTableDataSource.TARGET1_STYLE_COL %>"/>
          </uix:contents>
        </uix:column>

        <%-- Target2 column --%>
        <uix:column columnFormatBinding="dataFormat@pageSegmentBean@">
          <uix:columnHeader>
            <uix:sortableHeader sortableBinding="target2_ecm_sort@tableDataSource@"
                                textBinding="target2Header@pageSegmentBean@" />
          </uix:columnHeader>
          <uix:contents>
            <uix:styledText textBinding="target2_ecm_col"
                            styleClassBinding="<%= CompSingleTableDataSource.TARGET2_STYLE_COL %>"/>
          </uix:contents>
        </uix:column>

      </uix:table>
    </uix:rowLayout>
    
  </uix:header>
</uix:dataScope>
</oem:pageSegment>
