<%--
  -- Page:        compare.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.CompareController
  -- Bean:        oracle.sysman.eml.ecm.generic.CompareBean
  --
  -- Description: This page displays a comparison of two ECM snapshots.
  --
  --  MODIFIED    (MM/DD/YY)
  --     jochen    01/26/06 - XbranchMerge jochen_bug-4991534 from main 
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     lappanmu  12/12/05 - Fix for oac 
  --     jochen    08/11/05 - 
  --     jochen    08/02/05 - UI review comments 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    07/29/05 - Review comments 
  --     jochen    04/20/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.CompareController" %>
<%@ page import="oracle.sysman.eml.ecm.generic.BaseCompTableDataSource" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundle --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="savedConfigMsgs"
              class="oracle.sysman.resources.eml.ecm.track.SavedConfigMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>

      <uix:dataScope currentDataBinding="compareBean@servletRequest">
        <%-- HTML Form --%>
        <uix:form name="compareForm"
                  method="post">
          <uix:formValue name="pageName" value="/ecm/generic/compare"/>
          <%--
               Note that if there is an error rendering the page segments,
               the quickLinks throw an exception when trying to render
               the child headers, so don't render quicklinks if we
               encounter an error
           --%>
          <uix:pageLayout titleBinding="pageHeader">

            <%-- Oracle Logo and Tabs, breadcrumb data from --%>
            <%-- controller getNavigatorPath()              --%>
            <%@ include file="/oemGlobal.jspf" %>

            <%--              --%>
            <%-- Errors       --%>
            <%--              --%>
            <uix:messages>
              <uix:stackLayout>
                <oem:messageBox messageTypeBinding="msgType@servletRequest"
                                errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText"
                                mainTextKey="mainText"/>
                <uix:spacer height="3"/>
              </uix:stackLayout>
            </uix:messages>

            <uix:contents>
              <uix:rowLayout width="100%">
                <%--                      --%>
                <%-- First Target Context --%>
                <%--                      --%>
                <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">

                  <%-- Link to first target homepage --%>
                  <uix:styledText textBinding="FIRST_TARGET@msgs"
                                     styleClass="OraFieldText"/>
                  <uix:link textBinding="firstTargetDisplayName"
                            id="firstTargetID"
                            destinationBinding="firstTargetDest"/>

                  <%-- Link to first host homepage --%>
                  <uix:styledText textBinding="HC_TARGET_NAME@HCmsgs"
                                  renderedBinding="showFirstHost"
                                  styleClass="OraFieldText"/>
                  <uix:link textBinding="firstHost"
                            renderedBinding="showFirstHost"
                            id="firstHostID"
                            destinationBinding="firstHostDest"/>

                  <%-- Link to first target view configuration --%>
                  <uix:styledText textBinding="COLLECTED@msgs"
                                   styleClass="OraFieldText"/>
                  <uix:stackLayout>
                    <uix:styledText textBinding="firstCollectDate"
                                    styleClass="OraDataText"
                                    renderedBinding="firstCollGone"
                                    destinationBinding="firstConfigDest"/>
                    <uix:styledText textBinding="COLL_GONE@msgs"
                                    styleClass="OraInlineInfoText"
                                    renderedBinding="firstCollGone"/>
                    <uix:link textBinding="firstCollectDate"
                              id="collectedID"
                              destinationBinding="firstConfigDest"
                              renderedBinding="firstCollAvail"/>
                  </uix:stackLayout>

                  <%-- First target saved configuration description --%>
                  <uix:messageStyledText promptBinding="LBL_DESC@savedConfigMsgs"
                                         renderedBinding="hasFirstDesc"
                                         textBinding="firstDesc"
                                         styleClass="OraDataText"/>
                </uix:labeledFieldLayout>

                <%--                       --%>
                <%-- Second Target Context --%>
                <%--                       --%>
                <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
                  <%-- Link to second target homepage --%>
                  <uix:styledText textBinding="SECOND_TARGET@msgs"                                  
                                  styleClass="OraFieldText"/>
                  <uix:link textBinding="secondTargetDisplayName"
                            id="secondTargetNameID"
                            destinationBinding="secondTargetDest"/>

                  <%-- Link to second host homepage --%>
                  <uix:styledText textBinding="HC_TARGET_NAME@HCmsgs"
                                  renderedBinding="showSecondHost"                                  
                                  styleClass="OraFieldText"/>
                  <uix:link id="secondHostID"
                            textBinding="secondHost"
                            renderedBinding="showSecondHost"
                            destinationBinding="secondHostDest"/>

                  <%-- Link to second target view configuration --%>
                  <uix:styledText textBinding="COLLECTED@msgs"                                  
                                  styleClass="OraFieldText"/>
                  <uix:stackLayout>
                    <uix:styledText textBinding="secondCollectDate"
                                    styleClass="OraDataText"                                    
                                    renderedBinding="secondCollGone"
                                    destinationBinding="secondConfigDest"/>
                    <uix:styledText textBinding="COLL_GONE@msgs"
                                    styleClass="OraInlineInfoText"
                                    renderedBinding="secondCollGone"/>
                    <uix:link textBinding="secondCollectDate"
                              id="collectedID2"
                              destinationBinding="secondConfigDest"
                              renderedBinding="secondCollAvail"/>
                  </uix:stackLayout>

                  <%-- Second target saved configuration description --%>
                  <uix:messageStyledText promptBinding="LBL_DESC@savedConfigMsgs"
                                         renderedBinding="hasSecondDesc"
                                         textBinding="secondDesc"
                                         styleClass="OraDataText"/>
                </uix:labeledFieldLayout>
              </uix:rowLayout>


              <%--          --%>
              <%-- Summary  --%>
              <%--          --%>
              <uix:spacer height="10"/>
              <uix:header textBinding="SUMMARY@msgs"/>

              <uix:stackLayout>
                <uix:labeledFieldLayout columns="3"
                                        width="0"
                                        labelWidth="0"
                                        fieldWidth="0">
                  <uix:contents childDataBinding="summaryTables">
                    <uix:spacer width="1"/>
                    <uix:rowLayout>
                      <uix:image sourceBinding="<%= BaseCompTableDataSource.SUMMARY_IMAGE_ATTR %>"
                                 shortDescBinding="DIFFERENT@msgs"
                                 destinationBinding="<%= BaseCompTableDataSource.ANCHOR_DEST_ATTR %>"/>
                      <uix:link textBinding="<%= BaseCompTableDataSource.ANCHOR_LABEL_ATTR %>"
                                destinationBinding="<%= BaseCompTableDataSource.ANCHOR_DEST_ATTR %>"/>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:labeledFieldLayout>

              </uix:stackLayout>
              <uix:separator/>

              <%--               --%>
              <%-- Compare Data  --%>
              <%--               --%>
              <uix:include nodeBinding="compareNode"/>

            </uix:contents>
          </uix:pageLayout>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

