<%--
  -- Page:        oneRowDetail.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.CompareController
  -- Bean:        oracle.sysman.eml.ecm.generic.CompareBean
  --
  -- Description: This page displays the comparison of one row in a
  --              multi-row table.
  --
  --  MODIFIED    (MM/DD/YY)
  --     jochen    01/26/06 - XbranchMerge jochen_bug-4991534 from main 
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     lappanmu  01/25/06 - Fix for oac
  --     jochen    08/11/05 - Add breadcrumb back to compare page 
  --     jochen    08/02/05 - Change target label 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    07/29/05 - Review comments 
  --     jochen    05/09/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.ecm.generic.JspConstants" %>
<%@ page import="oracle.sysman.eml.ecm.generic.BaseCompTableDataSource" %>
<%@ page import="oracle.sysman.eml.ecm.generic.CompareController" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundle --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="savedConfigMsgs"
              class="oracle.sysman.resources.eml.ecm.track.SavedConfigMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>

      <uix:dataScope currentDataBinding="compareBean@servletRequest">
        <%-- HTML Form --%>
        <uix:form name="oneRowForm"
                  method="post">
          <uix:formValue name="pageName" value="/ecm/generic/oneRowDetail"/>
          <uix:pageLayout titleBinding="pageHeader@detailBean@servletRequest">

            <%-- Oracle Logo and Tabs, breadcrumb data from --%>
            <%-- controller getNavigatorPath()              --%>
            <%@ include file="/oemGlobal.jspf" %>

            <%--              --%>
            <%-- Errors       --%>
            <%--              --%>
            <uix:messages>
              <uix:stackLayout>
                <oem:messageBox messageTypeBinding="msgType@servletRequest"
                                errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText"
                                mainTextKey="mainText"/>
                <uix:spacer height="3"/>
              </uix:stackLayout>
            </uix:messages>


            <uix:contents>
           
              <uix:stackLayout>
              <uix:rowLayout width="100%">
                <%-- TEMP - need to put this in an include file --%>
                <%-- shared with compare.jsp                    --%>
                <%--                      --%>
                <%-- First Target Context --%>
                <%--                      --%>
                
                <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">

                  <%-- Link to first target homepage --%>
                  <uix:styledText textBinding="FIRST_TARGET@msgs"
                                 styleClass="OraFieldText"/>
                  <uix:link textBinding="firstTargetName"
                            id="firstTargetID"
                            destinationBinding="firstTargetDest"/>

                  <%-- Link to first host homepage --%>
                  <uix:styledText textBinding="HC_TARGET_NAME@HCmsgs"
                                  renderedBinding="showFirstHost"
                        styleClass="OraFieldText"/>
                  <uix:link textBinding="firstHost"
                            renderedBinding="showFirstHost"
                            id="firstHostID"
                            destinationBinding="firstHostDest"/>

                  <%-- Link to first target view configuration --%>
                  <uix:styledText textBinding="COLLECTED@msgs"
                             styleClass="OraFieldText"/>
                  <uix:stackLayout>
                    <uix:styledText textBinding="firstCollectDate"
                                    styleClass="OraDataText"
                                   renderedBinding="firstCollGone"
                                    destinationBinding="firstConfigDest"/>
                    <uix:styledText textBinding="COLL_GONE@msgs"
                                    styleClass="OraInlineInfoText"
                                    renderedBinding="firstCollGone"/>
                    <uix:link textBinding="firstCollectDate"
                              id="collectedID"
                              destinationBinding="firstConfigDest"
                              renderedBinding="firstCollAvail"/>
                  </uix:stackLayout>

                  <%-- First target saved configuration description --%>
                  <uix:messageStyledText promptBinding="LBL_DESC@savedConfigMsgs"
                                         renderedBinding="hasFirstDesc"
                                         textBinding="firstDesc"
                                         styleClass="OraDataText"/>
                </uix:labeledFieldLayout>

                <%--                       --%>
                <%-- Second Target Context --%>
                <%--                       --%>
                <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0">
                  <%-- Link to second target homepage --%>
                  <uix:styledText textBinding="SECOND_TARGET@msgs"                                  
                                  styleClass="OraFieldText"/>
                  <uix:link textBinding="secondTargetName"
                            id="secondTargetNameID"
                            destinationBinding="secondTargetDest"/>

                  <%-- Link to second host homepage --%>
                  <uix:styledText textBinding="HC_TARGET_NAME@HCmsgs"
                                  renderedBinding="showSecondHost"                                  
                                  styleClass="OraFieldText"/>
                  <uix:link id="secondHostID"
                            textBinding="secondHost"
                            renderedBinding="showSecondHost"
                            destinationBinding="secondHostDest"/>

                  <%-- Link to second target view configuration --%>
                  <uix:styledText textBinding="COLLECTED@msgs"                                  
                                  styleClass="OraFieldText"/>
                  <uix:stackLayout>
                    <uix:styledText textBinding="secondCollectDate"
                                    styleClass="OraDataText"                                    
                                    renderedBinding="secondCollGone"
                                    destinationBinding="secondConfigDest"/>
                    <uix:styledText textBinding="COLL_GONE@msgs"
                                    styleClass="OraInlineInfoText"
                                    renderedBinding="secondCollGone"/>
                    <uix:link textBinding="secondCollectDate"
                              id="collectedID2"
                              destinationBinding="secondConfigDest"
                              renderedBinding="secondCollAvail"/>
                  </uix:stackLayout>

                  <%-- Second target saved configuration description --%>
                  <uix:messageStyledText promptBinding="LBL_DESC@savedConfigMsgs"
                                         renderedBinding="hasSecondDesc"
                                         textBinding="secondDesc"
                                         styleClass="OraDataText"/>
                </uix:labeledFieldLayout>
              </uix:rowLayout>
             </uix:stackLayout> 
             
              
             <uix:switcher childNameBinding="showParentContext"> 
                <uix:case name="true">
                    <uix:ref refID="ecm/generic/compSingleRow"/>
               </uix:case>             
            </uix:switcher>
            
             <!--<uix:spacer height="10"/> -->
            <uix:switcher childNameBinding="showSummary">
                <uix:case name="true"> 
                 <uix:separator/>
                   <uix:header textBinding="SUMMARY@msgs">                   
                   <uix:stackLayout>
                   <uix:labeledFieldLayout columns="3"
                                        width="0"
                                        labelWidth="0"
                                        fieldWidth="0">
                    <uix:contents childDataBinding="summaryTables">
                    <uix:spacer width="1"/>
                    <uix:rowLayout>
                      <uix:image sourceBinding="<%= BaseCompTableDataSource.SUMMARY_IMAGE_ATTR %>"
                                 shortDescBinding="DIFFERENT@msgs"
                                 destinationBinding="<%= BaseCompTableDataSource.ANCHOR_DEST_ATTR %>"/>
                      <uix:link textBinding="<%= BaseCompTableDataSource.ANCHOR_LABEL_ATTR %>"
                                destinationBinding="<%= BaseCompTableDataSource.ANCHOR_DEST_ATTR %>"/>
                    </uix:rowLayout>
                    
                  </uix:contents>
                 </uix:labeledFieldLayout>
               </uix:stackLayout>
                <uix:separator/>
              </uix:header>
             </uix:case>
             </uix:switcher>
            
              <uix:include nodeBinding="compareNode"/>
            </uix:contents>
          </uix:pageLayout>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

