<%--
  -- Page:        view.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.ViewController
  -- Bean:        oracle.sysman.eml.ecm.generic.ViewBean
  --
  -- Description: This page displays a snapshot.
  --
  --  MODIFIED    (MM/DD/YY)
  --     agor      02/27/06 - fix ada 
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     jochen    08/08/05 - Add refresh 
  --     jochen    08/02/05 - Add target context 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    03/28/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.ViewController" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundle --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="savedConfigMsgs"
              class="oracle.sysman.resources.eml.ecm.track.SavedConfigMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

      <uix:dataScope currentDataBinding="viewBean@servletRequest">
        <%-- HTML Form --%>
        <uix:form name="viewForm"
                  method="post">
          <uix:formValue name="pageName" value="/ecm/generic/view"/>
          <%--
               Note that if there is an error rendering the page segments,
               the quickLinks throw an exception when trying to render
               the child headers, so don't render quicklinks if we
               encounter an error
           --%>
          <uix:pageLayout titleBinding="pageHeader"
                          quickLinksShownBinding="hasValidDisplay">

            <%-- Oracle Logo and Tabs, breadcrumb data from --%>
            <%-- controller getNavigatorPath()              --%>
            <%@ include file="/oemGlobal.jspf" %>

            <%--              --%>
            <%-- Errors       --%>
            <%--              --%>
            <uix:messages>
              <uix:stackLayout>
                <oem:messageBox messageTypeBinding="msgType@servletRequest"
                                errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText"
                                mainTextKey="mainText"/>
                <uix:spacer height="3"/>
              </uix:stackLayout>
            </uix:messages>

            <%--              --%>
            <%-- Buttons      --%>
            <%--              --%>
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="SAVE_HOSTCONFIG@HCmsgs"
                                  shortDescBinding="SAVE_HOSTCONFIG@HCmsgs"
                                  name="event"
                                  disabledBinding="noValidDisplay"
                                  value="<%= ViewController.SAVE_EVENT %>" />

                <uix:submitButton textBinding="BTN_COMPARE_CONFIG@savedConfigMsgs"
                                  shortDescBinding="BTN_COMPARE_CONFIG@savedConfigMsgs"
                                  name="event"
                                  disabledBinding="noValidDisplay"
                                  value="<%= ViewController.COMPARE_EVENT %>" />

                <uix:submitButton textBinding="BTN_COMPARE_MULTIPLE_CONFIG@savedConfigMsgs"
                                  shortDescBinding="BTN_COMPARE_MULTIPLE_CONFIG@savedConfigMsgs"
                                  name="event"
                                  disabledBinding="noValidDisplay"
                                  value="<%= ViewController.COMPARE_MULTIPLE_EVENT %>" />

                <uix:submitButton textBinding="BTN_HISTORY@HCmsgs"
                                  shortDescBinding="BTN_HISTORY@HCmsgs"
                                  disabledBinding="noValidDisplay"
                                  name="event"
                                  value="<%= ViewController.HISTORY_EVENT %>" />
                <uix:button textBinding="REFRESH@sdkMsgs"
                            destinationBinding="refreshLink"
                            renderedBinding="isCurrent"/>

              </uix:pageButtonBar>
            </uix:pageButtons>

            <%--                --%>
            <%-- Snapshot Data  --%>
            <%--                --%>
            <uix:contents>

              <%--                --%>
              <%-- Target Context --%>
              <%--                --%>
              <uix:labeledFieldLayout width="0" fieldWidth="0" labelWidth="0"
                                      renderedBinding="hasValidDisplay">

                <%-- Link to first target view configuration --%>
                <uix:styledText textBinding="COLL_FROM_TARGET@sdkMsgs"
                                styleClass="OraFieldText"/>
                <uix:styledText textBinding="collectDate"
                                styleClass="OraDataText"/>

                <%-- First target saved configuration save time --%>
                <uix:messageStyledText promptBinding="LBL_SAVED_TIME@savedConfigMsgs"
                                       renderedBinding="isSaved"
                                       textBinding="savedDate"
                                       styleClass="OraDataText"/>

                <%-- First target saved configuration description --%>
                <uix:messageStyledText promptBinding="LBL_DESC@savedConfigMsgs"
                                       renderedBinding="hasDesc"
                                       textBinding="desc"
                                       styleClass="OraDataText"/>
              </uix:labeledFieldLayout>

              <uix:separator/>

              <%--               --%>
              <%-- Page segments --%>
              <%--               --%>
              <uix:include nodeBinding="viewNode"/>
            </uix:contents>

          </uix:pageLayout>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

