<%--
  -- Page:        view.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.ViewController
  -- Bean:        oracle.sysman.eml.ecm.generic.ViewBean
  --
  -- Description: This page displays a snapshot.
  --
  --  MODIFIED    (MM/DD/YY)
  --     lappanmu  12/04/05 - 
  --     jochen    08/08/05 - Add refresh 
  --     jochen    08/02/05 - Add target context 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    03/28/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.ViewController" %>
<%@ page import="oracle.sysman.eml.ecm.generic.ViewBean" %>

<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <%-- Message Bundle --%>
  <uix:bundle name="msgs"
              class="oracle.sysman.eml.ecm.generic.GenericUIMsg"/>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>
  <uix:bundle name="savedConfigMsgs"
              class="oracle.sysman.resources.eml.ecm.track.SavedConfigMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>

  <uix:document>
 
    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>   

    <uix:body>
     
  
      <uix:dataScope currentDataBinding="viewBean@servletRequest">
      
        <%-- HTML Form --%>
        <uix:form name="viewForm"
                  method="post">
          <uix:formValue name="pageName" value="/ecm/generic/viewChildren"/>
          <%--
               Note that if there is an error rendering the page segments,
               the quickLinks throw an exception when trying to render
               the child headers, so don't render quicklinks if we
               encounter an error
           --%>
          <uix:pageLayout titleBinding="pageTitle"
                          quickLinksShownBinding="hasValidDisplay">

            <%-- Oracle Logo and Tabs, breadcrumb data from --%>
            <%-- controller getNavigatorPath()              --%>
            <%@ include file="/oemGlobal.jspf" %>

            <%--              --%>
            <%-- Errors       --%>
            <%--              --%>
            <uix:messages>
              <uix:stackLayout>
                <oem:messageBox messageTypeBinding="msgType@servletRequest"
                                errorTableBinding="errors@servletRequest"
                                titleTextKey="titleText"
                                mainTextKey="mainText"/>
                <uix:spacer height="3"/>
              </uix:stackLayout>
            </uix:messages>

          
            <%--                --%>
            <uix:contents>

              
              <%--               --%>
              <%-- Page segments --%>
              <%--               --%>
              <uix:include nodeBinding="viewNode"/>
            </uix:contents>

          </uix:pageLayout>
        </uix:form>
      </uix:dataScope>
    </uix:body>
  </uix:document>
</uix:renderingContext>

