<%--
  -- Page:        viewMultiRow.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.ViewMultiPageSegController
  -- Bean:        oracle.sysman.eml.ecm.generic.ViewMultiPageSegBean
  --
  -- Description: This page segment displays the contents of a
  --              multi-row table for a snapshot
  --
  --  MODIFIED    (MM/DD/YY)
  --     jochen    08/01/05 - jochen_view1
  --     jochen    04/12/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.JspConstants" %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.eml.ecm.generic.ViewMultiPageSegBean' %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>

  <%-- Message bundles --%>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>

  <%
    PageSegmentContext psc =
            (PageSegmentContext)request.getAttribute("pageSegmentContext");
    ViewMultiPageSegBean segBean =
            (ViewMultiPageSegBean)psc.getPageSegmentBean();
  %>
  <uix:header textBinding="<%= segBean.getFullTableNameAttr() %>">
    <uix:tableLayout width="100%">

      <%--                --%>
      <%-- History button --%>
      <%--                --%>
      <uix:rowLayout width="100%" hAlign="right">
        <uix:link textBinding="BTN_HISTORY@HCmsgs"
                  longDescBinding="histLongDesc@pageSegmentBean@"
                  destinationBinding="historyDest@pageSegmentBean@"/>
      </uix:rowLayout>

      <%--        --%>
      <%-- Errors --%>
      <%--        --%>
      <%-- This is only shown if there was an error creating the  --%>
      <%-- display node.  The error is logged and an inline error --%>
      <%-- message is displayed on the page so other segments     --%>
      <%-- can still be rendered                                  --%>
      <uix:rowLayout id="<%= segBean.getSegID() + JspConstants.ERROR %>">
        <uix:styledText textBinding="<%= JspConstants.ERROR %>"
                        styleClass="OraInlineErrorText"/>
      </uix:rowLayout>

      <%--       --%>
      <%-- Table --%>
      <%--       --%>
      <uix:rowLayout>
        <uix:ref refID="<%= segBean.getSegID() %>" />
      </uix:rowLayout>

    </uix:tableLayout>
  </uix:header>
</uix:dataScope>
</oem:pageSegment>
