<%--
  -- Page:        viewSingleRow.jsp
  -- Controller:  oracle.sysman.eml.ecm.generic.ViewSinglePageSegController
  -- Bean:        oracle.sysman.eml.ecm.generic.ViewSinglePageSegBean
  --
  -- Description: This page segment displays the contents of a
  --              single-row table or name/value pairs for a snapshot
  --
  --  MODIFIED    (MM/DD/YY)
  --     lappanmu  12/13/05 - XbranchMerge lappanmu_bug-4684929 from main 
  --     lappanmu  10/06/05 - 
  --     jochen    08/01/05 - jochen_view1
  --     jochen    03/25/05 - Creation
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.ecm.generic.JspConstants" %>
<%@ page import='oracle.sysman.emSDK.page.seg.PageSegmentContext' %>
<%@ page import='oracle.sysman.eml.ecm.generic.ViewSinglePageSegBean' %>
<%@ page import="oracle.sysman.eml.ecm.generic.ViewController" %>

<%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<oem:pageSegment>

<uix:dataScope>

  <%-- Message bundles --%>
  <uix:bundle name="HCmsgs"
              class="oracle.sysman.eml.ecm.resources.HCResourceBundle"/>

  <%
    PageSegmentContext psc =
            (PageSegmentContext)request.getAttribute("pageSegmentContext");
    ViewSinglePageSegBean segBean =
            (ViewSinglePageSegBean)psc.getPageSegmentBean();
  %>
  <uix:header textBinding="<%= segBean.getFullTableNameAttr() %>">
    <uix:tableLayout width="100%">

      <%--                --%>
      <%-- History button --%>
      <%--                --%>
      <uix:rowLayout width="100%" hAlign="right">
        <uix:link textBinding="BTN_HISTORY@HCmsgs"
                  longDescBinding="histLongDesc@pageSegmentBean@"
                  destinationBinding="historyDest@pageSegmentBean@"/>
      </uix:rowLayout>

      <%--                  --%>
      <%-- Name/value pairs --%>
      <%--                  --%>
      <uix:rowLayout width="100%">
        <uix:labeledFieldLayout width="0" labelWidth="0" fieldWidth="0" >
          <uix:contents childDataBinding="singleRowData@pageSegmentBean@">
            <uix:styledText textBinding="<%= JspConstants.LABEL %>"
                            styleClass="OraFieldText"/>
             <uix:switcher childNameBinding="isLink">
              <uix:case name="true">
                 <uix:link textBinding="<%= JspConstants.LINKNAME %>" 
                           destinationBinding="<%= JspConstants.VALUE %>"/>
              </uix:case>
              <uix:default>
            <uix:styledText textBinding="<%= JspConstants.VALUE %>"
                            styleClass="OraDataText"/>
               </uix:default>
               </uix:switcher>
          </uix:contents>
           
        </uix:labeledFieldLayout>
      
      </uix:rowLayout> 
      
    
      

      <%--              --%>
      <%-- Errors       --%>
      <%--              --%>
      <%-- This is only shown if there was an error creating the  --%>
      <%-- display node.  The error is logged and an inline error --%>
      <%-- message is displayed on the page so other segments     --%>
      <%-- can still be rendered                                  --%>
      <uix:rowLayout>
        <uix:contents childDataBinding="singleRowData@pageSegmentBean@">
          <uix:styledText textBinding="<%= JspConstants.ERROR %>"
                          styleClass="OraInlineErrorText"/>
        </uix:contents>
      </uix:rowLayout>

    </uix:tableLayout>
  </uix:header>
</uix:dataScope>
</oem:pageSegment>
