<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--
  -- Page:        configDetail.jsp
  -- Controller:  oracle.sysman.eml.ecm.history.ConfigHistoryController
  --
  -- Description: Launched when user selects "detail" action
  --
  --  MODIFIED    (MM/DD/YY)
  --    mgoodric   07/03/05 - fix ppr (enabled)
  --    mgoodric   01/29/05 - fix common elements 
  --    mgoodric   01/26/05 - rearrange common fields 
  --    mgoodric   12/28/04 - cleanup 
  --    mgoodric   12/13/04 - changes from Exit UI review 
  --    mgoodric   11/24/04 - remove obsolete metaContainer
  --    mgoodric   11/18/04 - use SDKUIMsg for "Page Refreshed"
  --    mgoodric   10/13/04 - add date range of discovery for history detail page 
  --    mgoodric   09/05/04 - mgoodric_ecm_config_history_040716
  --    mgoodric   07/16/04 - modified to represent Enterprise Configuration History
  --%>

<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.history.util.ConfigHistoryConstants" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle
     name="ConfigHistoryMsg"
     class="oracle.sysman.resources.eml.ecm.history.ConfigHistoryMsg"
  />
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <%-- Body tag will indent page from edge of window --%>
    <uix:body>
      <uix:form name="configDetailForm" destination="configDetail" method="post">
        <uix:formValue name="pageName" value="/ecm/history/configDetail"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">

         <%@ include file="configHeader.jspf" %>

          <uix:stackLayout>

            <uix:spacer height="0" width="0"/>

            <uix:tableLayout cellSpacing="5" width="90%">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="LBL_CATEGORY@ConfigHistoryMsg"/>
                  <uix:spacer height="0" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" wrappingDisabled="true">
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="category@defaultBean@servletRequest"
                  />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="LBL_TARGETNAME@ConfigHistoryMsg"/>
                  <uix:spacer height="0" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" wrappingDisabled="true">
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="targetName@defaultBean@servletRequest"
                  />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                  <uix:messagePrompt promptBinding="LBL_OPERATION@ConfigHistoryMsg"/>
                  <uix:spacer height="0" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" wrappingDisabled="true">
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="operation@defaultBean@servletRequest"
                  />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true" 
                   renderedBinding="hostNameRendered@defaultBean@servletRequest">
                  <uix:messagePrompt promptBinding="LBL_HOSTNAME@ConfigHistoryMsg"/>
                  <uix:spacer height="0" width="5"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" wrappingDisabled="true"
                    renderedBinding="hostNameRendered@defaultBean@servletRequest">
                  <uix:styledText
                    styleClass="OraDataText"
                    textBinding="hostName@defaultBean@servletRequest"
                  />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:contents> <uix:separator/> </uix:contents>

            <uix:tableLayout cellSpacing="5" width="90%">
              <uix:contents 
                childDataBinding="unchangedAttributes@defaultBean@servletRequest">
                <%-- Descriptor/Attribute --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="center" width="18%" wrappingDisabled="true">
                    <uix:messagePrompt promptBinding="<%=ConfigHistoryConstants.S_PROMPT_ATTR%>"/>
                    <uix:spacer height="0" width="5"/>
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="left">
                    <uix:styledText
                      styleClass="OraDataText"
                      textBinding="<%=ConfigHistoryConstants.S_TEXT_ATTR%>"
                    />
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>

            <uix:tableLayout>
              <uix:contents
                childDataBinding="changedAttributes@defaultBean@servletRequest">
                <%-- Attribute--%>
                <uix:header size="2" textBinding="<%=ConfigHistoryConstants.S_HEADER_ATTR%>">
                  <uix:tableLayout cellSpacing="5" width="90%">

                    <%-- New Value--%>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" vAlign="center" width="15%" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="<%=ConfigHistoryConstants.S_NEW_PROMPT_ATTR%>"/>
                        <uix:spacer height="0" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText
                          styleClass="OraDataText"
                          textBinding="<%=ConfigHistoryConstants.S_NEW_TEXT_ATTR%>"
                        />
                      </uix:cellFormat>
                    </uix:rowLayout>
    
                    <%-- Old Value --%>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" vAlign="center" width="15%" wrappingDisabled="true">
                        <uix:messagePrompt promptBinding="<%=ConfigHistoryConstants.S_OLD_PROMPT_ATTR%>"/>
                        <uix:spacer height="0" width="5"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText
                          styleClass="OraDataText"
                          textBinding="<%=ConfigHistoryConstants.S_OLD_TEXT_ATTR%>"
                        />
                      </uix:cellFormat>
                    </uix:rowLayout>

                  </uix:tableLayout>
                </uix:header>
              </uix:contents>
            </uix:tableLayout>

          </uix:stackLayout>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%-- End of File --%>
