<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--
  -- Page:        configHistory.jsp
  -- Controller:  oracle.sysman.eml.ecm.history.ConfigHistoryController
  --
  -- Description: Launched when user clicks on "Configuration History" link
  --
  --  MODIFIED    (MM/DD/YY)
  --    mgoodric   07/03/05 - fix ppr (enabled)
  --    mgoodric   12/14/04 - add ppr (disabled)
  --    mgoodric   12/13/04 - changes from Exit UI review
  --    mgoodric   11/24/04 - remove obsolete metaContainer
  --    mgoodric   11/18/04 - use SDKUIMsg for "Page Refreshed" 
  --    mgoodric   11/08/04 - implement new history page design 
  --    mgoodric   09/24/04 - fix location of Page Refreshed 
  --    mgoodric   09/21/04 - fix form name for nameBinding
  --    mgoodric   09/08/04 - add Save To File and Search Using Sql support 
  --    mgoodric   09/05/04 - mgoodric_ecm_config_history_040716
  --    mgoodric   07/25/04 - modified to represent Enterprise Configuration History
  --%>

<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.history.util.ConfigHistoryConstants" %>
<%@ page import="oracle.sysman.eml.ecm.util.table.UIXDataSource" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle 
    name="ConfigHistoryMsg"
    class="oracle.sysman.resources.eml.ecm.history.ConfigHistoryMsg"
  />
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>

    <%-- Body tag will indent page from edge of window --%>
    <uix:body>
      <uix:form nameBinding="eml_ecm_sc_formName@servletRequest" method="post">
        <uix:formValue name="pageName" value="/ecm/history/configHistory"/>
        <uix:formValue name="guid" valueBinding="guid@defaultBean@servletRequest"/>

        <uix:pageLayout
          titleBinding="pageHeader@defaultBean@servletRequest">

          <%@ include file="configHeader.jspf" %>

          <uix:stackLayout>

            <%@ include file="configSearch.jspf" %>
            <%@ include file="configTable.jspf" %>

          </uix:stackLayout>

        </uix:pageLayout>
     </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

<%-- End of File --%>
