<%--
  -- Page:        configHistorySegment.jsp
  -- Controller:  oracle.sysman.eml.ecm.history.ConfigHistorySegmentHandler
  --
  -- Description: Page segment which can be included in any group context page
  --
  --  MODIFIED    (MM/DD/YY)  
  --  niramach    02/25/05 - Enable PPR. 
  --  niramach    09/28/04 - Header is added. 
  --  niramach    09/24/04 - niramach_confighistpageseglatest
  --  niramach    09/14/04 - Creation
  --%>
  <%@ page contentType="text/html; charset=UTF-8"%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%@ page import="oracle.sysman.eml.ecm.history.util.ConfigHistoryConstants"%>
  <%-- oem:pagesegment tag will create a UINode and store the instance specific
     pagecontext in it.
--%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <%@ include file="/enablePPR.jspf"%>
  <oem:pageSegment>
      <uix:header textBinding="TITLE_CONFIGURATION_CHANGES@configHistorySegBundle@">
     
      <uix:rowLayout>
        <uix:styledText styleClass="OraFieldText" 
            textBinding="configHistoryInfoText@configHistorySegJspBean@"/>
      </uix:rowLayout>
      <uix:spacer height="15"/>
      <uix:rowLayout>
        <%--Configuration changes HGRID--%>
        <uix:hGrid id="ConfigHistoryGrid" 
            width="350" 
            alternateTextBinding="MSG_PRESSSEARCH@configHistorySegBundle@" 
            summaryBinding="TITLE_CONFIGURATION_CHANGES@configHistorySegBundle@" 
            treeDataBinding="configHistoryDataSrc@configHistorySegJspBean@" 
            proxyBinding="ConfigHistoryHGridProxy@" 
            partialRenderMode="self"
            formSubmitted="true">
          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="LBL_CATEGORY@configHistorySegBundle@"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>
          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="LBL_CHANGES_COUNT@configHistorySegBundle@"/>
            </uix:columnHeader>
             <uix:columnFormat columnDataFormat="numberFormat"/>
            <uix:link textBinding="<%=ConfigHistoryConstants.S_CHANGES_COUNT%>" 
                destinationBinding="<%=ConfigHistoryConstants.S_COUNT_URL%>"/>
          </uix:column>
        </uix:hGrid>
      </uix:rowLayout>
     </uix:header>     
    </oem:pageSegment>
</uix:renderingContext>