<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--
  -- Page:        configProcessing.jsp
  -- Controller:  oracle.sysman.eml.ecm.history.ConfigHistoryController
  --
  -- Description: Launched when user clicks on "Go" button
  --
  --  MODIFIED    (MM/DD/YY)
  --    mgoodric   05/08/05 - redo layout to be compatible with processPage 
  --    mgoodric   03/31/05 - add compatible Search in Progress message 
  --    mgoodric   01/19/05 - add support for changing Processing page time-interval 
  --    mgoodric   12/28/04 - cleanup
  --    mgoodric   12/07/04 - add bubble text 
  --    mgoodric   12/03/04 - mgoodric_cfghist_add_processing_page_041202
  --    mgoodric   12/02/04 - Initial version
  --%>

<%-- Imports --%>
<%@ page import="oracle.sysman.eml.ecm.history.util.ConfigHistoryConstants" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:bundle 
    name="ConfigHistoryMsg"
    class="oracle.sysman.resources.eml.ecm.history.ConfigHistoryMsg"
  />

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/setRefreshRate.jspf" %>

    <uix:body>
      <uix:contents>
        <uix:form name="configProcessing" method="post">
  
          <uix:pageLayout
            messageType="processing"
            titleBinding="TITLE_PROCESSING_SEARCH@ConfigHistoryMsg">

            <%@ include file="/oemGlobal.jspf" %>
  
            <uix:flowLayout>
              <uix:spacer width="10"/>
              <uix:styledText
                styleClass="OraInstructionTextStrong"
                textBinding="TEXT_PROCESSING_SEARCH@ConfigHistoryMsg"
              />
            </uix:flowLayout>

            <uix:spacer height="5"/>

            <uix:flowLayout>
              <uix:spacer width="10"/>
              <uix:styledText
                styleClass="OraInstructionText"
                textBinding="TEXT_PROCESSING_INFO@ConfigHistoryMsg"
              />
            </uix:flowLayout>

            <uix:spacer height="10"/>

            <uix:processing
              timeIntervalBinding="processingPageInterval@defaultBean@servletRequest">
              <uix:contents>
                <uix:styledText
                  styleClass="OraProcessingStatusFixed"
                  textBinding="MSG_PROCESS_IN_PROGRESS@ConfigHistoryMsg"
                />
              </uix:contents>
            </uix:processing>
  
           <uix:contentFooter>
             <uix:pageButtonBar>
               <uix:submitButton
                 name="event"
                 value="<%=ConfigHistoryConstants.CANCEL_PROCESSING_EVENT%>"
                 textBinding="BTN_CANCEL@ConfigHistoryMsg"
                 shortDescBinding="BTN_CANCEL@ConfigHistoryMsg"
               />
             </uix:pageButtonBar>
           </uix:contentFooter>
  
          </uix:pageLayout>
        </uix:form>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

