<%--
  - FILE
  -   complianceAllGroups.jsp
  -
  - DESCRIPTION
  -   Page showing compliance information of all the Groups.
  -
  - MODIFIED  (MM/DD/YY)
  -   ramalhot 03/06/06 - 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  03/24/05 - UI review bug fixes 
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   achugh   12/29/04 - to add licensing tags 
  -   tasingh  10/04/04 - set max input limit for messageTextInput 
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        textBinding="COMPLIANCE_ALL_GROUPS_INST_TEXT@hostPatchResourceBundle"
        styleClass="OraInstructionText"/>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>
    
  <%--Search Message Box--%>
  <uix:tableLayout width="100%">
    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:messageTextInput
          name="groupRegex"
          promptBinding="SEARCH@commonResourceBundle"
          maximumLength="255"
          textBinding="groupRegex@servletRequest">
          <uix:end>
            <uix:flowLayout>
              <uix:submitButton
                name="event"
                value="search"
                formNameBinding="formName@servletRequest"
                textBinding="GO@commonResourceBundle"/>
            </uix:flowLayout>
          </uix:end>
        </uix:messageTextInput>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>

  <%--
    - This table uses partial renderring mode. So id attribute is must. Also
    - partial renderring requires "/enablePPR.jspf" to be included, which is
    - inculded in the template.jspf
  --%>
  <uix:table
    width="80%"
    name="complianceAllGroupsTable"
    id="complianceAllGroupsTableID"
    summaryBinding="COMPLIANCE_ALL_GROUPS_SUMMARY@hostPatchResourceBundle"
    partialRenderMode="self"
    formSubmitted="true"
    alternateTextBinding="MSG_NO_GROUPS_FOUND@hostPatchResourceBundle"
    tableDataBinding="rows@complianceAllGroupsBean@servletRequest"
    valueBinding="currentValue@complianceAllGroupsBean@servletRequest"
    minValueBinding="minValue@complianceAllGroupsBean@servletRequest"
    blockSizeBinding="blockSize@complianceAllGroupsBean@servletRequest"
    maxValueBinding="maxValue@complianceAllGroupsBean@servletRequest"
    columnHeaderDataBinding="colHeaders@complianceAllGroupsBean@servletRequest">

    <uix:tableFormat tableBanding="rowBanding"/>

    <uix:columnHeaderStamp>
      <uix:sortableHeader
        textBinding="text"
        sortableBinding="sortable">
      </uix:sortableHeader>
    </uix:columnHeaderStamp>

    <oem:license>
      <uix:styledText
        textBinding="groupName"
        destinationBinding="groupNameDest">
      </uix:styledText>
    </oem:license>

    <uix:column>
      <uix:columnFormat
        columnDataFormat="iconButtonFormat"/>
      <uix:image
        sourceBinding="imgSrc"
        shortDescBinding="status"/>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numTotalHosts">
      </uix:styledText>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numOutOfDateHosts">
      </uix:styledText>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numRogueHosts">
      </uix:styledText>
    </uix:column>

  </uix:table>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
