<%--
  - FILE
  -   complianceAllHosts.jsp
  -
  - DESCRIPTION
  -   Page showing the compliance information of all the Hosts.
  -
  - MODIFIED  (MM/DD/YY)
  -   ramalhot 03/06/06 - 
  -   tasingh  07/13/05 - ADA bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  03/27/05 - UI review bug fixes 
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   achugh   12/29/04 - to add licensing tags 
  -   tasingh  10/04/04 - set max input limit for textInput
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/05/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        textBinding="COMPLIANCE_ALL_HOSTS_INST_TEXT@hostPatchResourceBundle"
        styleClass="OraInstructionText"/>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>

  <%--Search Message Box--%>
  <uix:rowLayout>

    <uix:cellFormat>
      <uix:messageChoice
        name="filter"
        promptBinding="SEARCH@commonResourceBundle"
        shortDescBinding="SEARCH@commonResourceBundle"
        selectedValueBinding="filterSelVal@servletRequest">
        <uix:contents
          childDataBinding="filterList@complianceAllHostsBean@servletRequest">
          <uix:option
            textBinding="filterOptionTxt"
            valueBinding="filterOptionVal"/>
        </uix:contents>
      </uix:messageChoice>
    </uix:cellFormat>

    <uix:spacer width="4"/>

    <uix:cellFormat>
      <uix:textInput
        name="hostRegex"
        textBinding="hostRegex@servletRequest"
        maximumLength="255"
        shortDescBinding="SEARCH@commonResourceBundle"
        columns="30"/>
    </uix:cellFormat>

    <uix:spacer width="4"/>

    <uix:cellFormat>
      <uix:submitButton
        name="event"
        value="search"
        formNameBinding="formName@servletRequest"
        textBinding="GO@commonResourceBundle"/>
    </uix:cellFormat>
  </uix:rowLayout>

  <uix:spacer height="10"/>

  <%--
    - This table uses partial renderring mode. So id attribute is must. Also
    - partial renderring requires "/enablePPR.jspf" to be included, which is
    - inculded in the template.jspf
    --%>
  <uix:table
    width="80%"
    name="complianceAllHostsTable"
    id="complianceAllHostsTableID"
    summaryBinding="COMPLIANCE_ALL_HOSTS_SUMMARY@hostPatchResourceBundle"
    partialRenderMode="self"
    formSubmitted="true"
    alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
    tableDataBinding="rows@complianceAllHostsBean@servletRequest"
    valueBinding="currentValue@complianceAllHostsBean@servletRequest"
    minValueBinding="minValue@complianceAllHostsBean@servletRequest"
    blockSizeBinding="blockSize@complianceAllHostsBean@servletRequest"
    maxValueBinding="maxValue@complianceAllHostsBean@servletRequest"
    columnHeaderDataBinding="colHeaders@complianceAllHostsBean@servletRequest">

    <uix:tableFormat tableBanding="rowBanding"/>

    <uix:columnHeaderStamp>
      <uix:sortableHeader
        textBinding="text"
        sortableBinding="sortable">
      </uix:sortableHeader>
    </uix:columnHeaderStamp>

    <oem:license>
      <uix:styledText
        textBinding="hostName"
        destinationBinding="hostNameDest">
      </uix:styledText>
    </oem:license>
    <oem:license>
      <uix:styledText
        textBinding="groupName"
        destinationBinding="groupNameDest">
      </uix:styledText>
    </oem:license>

    <uix:column>
      <uix:columnFormat
        columnDataFormat="iconButtonFormat"/>
      <uix:image
        sourceBinding="imgSrc"
        shortDescBinding="status"/>
    </uix:column>
    <uix:styledText
      textBinding="needsReboot">
    </uix:styledText>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numOutOfDatePkgs">
      </uix:styledText>
    </uix:column>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numRoguePkgs">
      </uix:styledText>
    </uix:column>

  </uix:table>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
