<%--
  - FILE
  -   complianceGroup.jsp
  -
  - DESCRIPTION
  -   Page showing the compliance information of a particular Group.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda 09/12/07 - remove schedule patching button in the bottom
  -   tasingh  08/14/07 - Bug:6189420 ADA bug
  -   aloganda 08/03/07 - bug-6271281 Disable Schedule Patching for zero
  -                       out-of-date pkgs
  -   aloganda 06/21/07 - ULN change Emergency Patching text to Patch Group
  -   aloganda 06/18/07 - ULN project
  -   hmodawel 03/06/06 - fix compilation error 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  03/27/05 - UI review bug fixes 
  -   tasingh  03/16/05 - Make minor chagnes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   achugh   12/29/04 - to add licensing tags 
  -   tasingh  10/05/04 - Handle the case when wrong group name or no group
  -                       name is passed
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/05/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <uix:rowLayout hAlign="right">
  <%@ include file="timestamp.jspf" %>
    <uix:spacer width="10"/>
    <uix:cellFormat columnSpan="2">
        <uix:button textBinding="PATCH_GROUP@hostPatchResourceBundle"
        disabledBinding="disableEpatchLink@complianceGroupBean@servletRequest"
   		destinationBinding="epatchLink@complianceGroupBean@servletRequest"/>
    </uix:cellFormat>
    </uix:rowLayout>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout cellSpacing="8" width="100%">

    <uix:rowLayout>
      <uix:cellFormat columnSpan="2">
        <uix:styledText
          textBinding="COMPLIANCE_GROUP_INST_TEXT@hostPatchResourceBundle"
          styleClass="OraInstructionText">
        </uix:styledText>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>

      <uix:cellFormat vAlign="top">
      <%--
        - This table uses partial renderring mode. So id attribute
        - is must. Also partial renderring requires "/enablePPR.jspf"
        - to be included, which is included in the template.jspf
        --%>
        <uix:table
          summary="compliancleGroup"
          width="100%"
          name="complianceGroupTable"
          id="complianceGroupTableID"
          partialRenderMode="self"
          formSubmitted="true"
          alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
          tableDataBinding="rows@complianceGroupBean@servletRequest"
          valueBinding="currentValue@complianceGroupBean@servletRequest"
          minValueBinding="minValue@complianceGroupBean@servletRequest"
          blockSizeBinding="blockSize@complianceGroupBean@servletRequest"
          maxValueBinding="maxValue@complianceGroupBean@servletRequest"
          columnHeaderDataBinding="colHeaders@complianceGroupBean@servletRequest">

          <uix:tableFormat tableBanding="rowBanding"/>

          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"
              sortableBinding="sortable">
            </uix:sortableHeader>
          </uix:columnHeaderStamp>

          <oem:license>
            <uix:styledText
              textBinding="host"
              destinationBinding="hostDest">
            </uix:styledText>
          </oem:license>
          <uix:column>
            <uix:columnFormat
              columnDataFormat="iconButtonFormat"/>
            <uix:image
              sourceBinding="imgSrc"
              shortDescBinding="status">
            </uix:image>
          </uix:column>

          <uix:column>
            <uix:columnFormat
              cellNoWrapFormat="true"
              columnDataFormat="numberFormat"/>
            <uix:styledText
              textBinding="numOutOfDatePkgs">
            </uix:styledText>
          </uix:column>

          <uix:column>
            <uix:columnFormat
              cellNoWrapFormat="true"
              columnDataFormat="numberFormat"/>
            <uix:styledText
              textBinding="numPkgsNeedingReboot">
            </uix:styledText>
          </uix:column>

          <uix:column>
            <uix:columnFormat
              cellNoWrapFormat="true"
              columnDataFormat="numberFormat"/>
            <uix:styledText
              textBinding="numRoguePkgs">
            </uix:styledText>
          </uix:column>

        </uix:table>
      </uix:cellFormat>

      <%--cell containing summary pie chart--%>
      <uix:cellFormat vAlign="top">
        <uix:contentContainer
          textBinding="SUMMARY@hostPatchResourceBundle"
          background="light"
          width="100%">

          <%--Total Hosts--%>
          <uix:rowLayout>
            <uix:cellFormat hAlign="right">
              <uix:styledText
                styleClass="OraFieldText"
                textBinding="TOTAL_HOSTS@hostPatchResourceBundle">
              </uix:styledText>
            </uix:cellFormat>
            <uix:spacer width="8"/>
            <uix:cellFormat hAlign="left">
              <uix:styledText
                styleClass="OraDataText"
                textBinding="numTotalHosts@complianceGroupBean@servletRequest">
              </uix:styledText>
            </uix:cellFormat>
          </uix:rowLayout>

          <%--Pie chart--%>
          <oem:chart
            chartType="pieChart"
            width="380"
            height="160"
            shortDescBinding="COMPLIANCE_SUMMARY@hostPatchResourceBundle"
            pieValuesInLegend="value"
            showSlicePercentLabels="true"
            pieSliceColorsBinding="pieChartColors@complianceGroupBean@servletRequest"
            backgroundColorBinding="pieChartBackgroundColor@complianceGroupBean@servletRequest"
            hideZeroSlices="true">

            <oem:boundChartDataSource
              chartDataSourceBinding="pieChartData@complianceGroupBean@servletRequest"/>

            <oem:chartColumn
              isKey="true"
              displayLabel=""
              sourceIndex="0"/>

            <oem:chartColumn
              displayLabel=""
              sourceIndex="1"/>
          </oem:chart>

        </uix:contentContainer>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
