<%--
  - FILE
  -   complianceHistory.jsp
  -
  - DESCRIPTION
  -   Page showing the compliance history of the HostPatching Groups.
  -
  - MODIFIED  (MM/DD/YY)
  -   ramalhot 03/06/06 - 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  06/15/05 - Use PPR to render dependent elements on change of 
  -                       dropdown list option 
  -   tasingh  03/27/05 - UI Review bug fixes 
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   achugh   12/29/04 - to add licensing tags 
  -   tasingh  10/07/04 - Correct the syntax of onClick="submitForm..."
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/23/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:spacer height="10"/>

  <uix:tableLayout cellSpacing="4" width="100%">
    <uix:rowLayout> 
      <uix:cellFormat>
        <uix:styledText 
          textBinding="COMPLIANCE_HISTORY_INST_TEXT@hostPatchResourceBundle"
          styleClass="OraInstructionText">
        </uix:styledText>
      </uix:cellFormat>
      <uix:cellFormat vAlign="top" hAlign="right"  columnSpan="2">
        <uix:messageChoice
          name="filter"
          promptBinding="VIEW_DATA@hostPatchResourceBundle"
          selectedValueBinding="filterSelValue@servletRequest"
          primaryClientActionBinding="onChangeFilter@servletRequest">

          <uix:contents
            childDataBinding="filterList@complianceHistoryBean@servletRequest">
            <uix:option
              textBinding="filterOptionTxt"
              valueBinding="filterOptionVal"/>
          </uix:contents>
        </uix:messageChoice>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>

  <%--table and the chart--%>
  <uix:tableLayout width="100%" id="dependentID">
    <uix:rowLayout>

      <%--cell containing table--%>
      <uix:cellFormat width="50%" vAlign="top">

        <uix:header
          textBinding="GROUPS@hostPatchResourceBundle">

          <%--
            - This table uses partial renderring mode. So id attribute
            - is must. Also partial renderring requires "/enablePPR.jspf"
            - to be included, which is inculded in the template.jspf
          --%>
          <uix:table
            width="100%"
            name="complianceHistory"
            id="complianceHistoryID"
            summaryBinding="COMPLIANCE_HISTORY_SUMMARY@hostPatchResourceBundle"
            partialRenderMode="self"
            formSubmitted="true"
            alternateTextBinding="MSG_NO_GROUPS_FOUND@hostPatchResourceBundle"
            tableDataBinding="rows@complianceHistoryBean@servletRequest"
            valueBinding="currentValue@complianceHistoryBean@servletRequest"
            minValueBinding="minValue@complianceHistoryBean@servletRequest"
            blockSizeBinding="blockSize@complianceHistoryBean@servletRequest"
            maxValueBinding="maxValue@complianceHistoryBean@servletRequest"
            columnHeaderDataBinding="colHeaders@complianceHistoryBean@servletRequest">

            <uix:tableFormat tableBanding="rowBanding"/>

            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"
                sortableBinding="sortable">
              </uix:sortableHeader>
            </uix:columnHeaderStamp>

            <oem:license>
              <uix:styledText
                textBinding="groupName"
                destinationBinding="groupNameDest">
              </uix:styledText>
            </oem:license>

            <uix:column>
              <uix:columnFormat
                cellNoWrapFormat="true"
                columnDataFormat="numberFormat"/>
              <oem:license>
                <uix:styledText
                  textBinding="numHosts"
                  destinationBinding="numHostsDest">
                </uix:styledText>
              </oem:license>
            </uix:column>

            <uix:column>
              <uix:columnFormat
                columnDataFormat="iconButtonFormat"/>
              <uix:image
                sourceBinding="viewImgSrc"
                destinationBinding="viewImgDest"
                shortDescBinding="viewImgShortDesc"/>
            </uix:column>

          </uix:table>
        </uix:header>
      </uix:cellFormat>

      <%--cell containing time series chart--%>
      <uix:cellFormat vAlign="top">

        <uix:header
          textBinding="chartHeader@complianceHistoryBean@servletRequest">

          <oem:chart chartType="timeSeriesChart"
            width="400"
            height="200"
            legendVisible="false"
            orientation="vertical"
            seriesColorsAutomatic="true"
            seriesSymbolsAutomatic="true"
            axisMax="100"
            timeGranularity="DAY"
            yAxisLabelIncrement="20"
            xAxisMinBinding="historyMin@complianceBean@servletRequest"
            xAxisMaxBinding="historyMax@complianceBean@servletRequest"
            yAxisLabelBinding="COMPLIANCE_PERCENTAGE@hostPatchResourceBundle">

            <uix:contents>
              <oem:boundChartDataSource
                chartDataSourceBinding="chartData@complianceHistoryBean@servletRequest"/>

              <oem:chartColumn
                displayLabelBinding="COMPLIANCE@hostPatchResourceBundle"
                sourceIndex="1"/>

              <oem:chartColumn
                isTimeColumn="true"
                displayLabel="Time"
                sourceIndex="0"/>
            </uix:contents>
          </oem:chart>
        </uix:header>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
