<%--
  - FILE
  -   complianceHome.jsp
  -
  - DESCRIPTION
  -   Compliance home page of Linux Host Patching Module.
  -
  - MODIFIED  (MM/DD/YY)
  -   somukher 06/14/07 - Adding link Deploy Config Files
  -   ramalhot 03/06/06 - 
  -   tasingh  11/30/05 - Bug:45809441 -ADA Compliance  
  -   tasingh  07/13/05 - ADA bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  05/05/05 - ER- 4327813 Add link for undo Patching 
  -   tasingh  03/24/05 - UI review bug fixes 
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  02/10/05 - Increase the width of pie chart 
  -   achugh   12/29/04 - to add licensing tags 
  -   tasingh  12/15/04 - ER-4046568: Provide links for all HostPatching jobs
  -   tasingh  10/04/04 - set max input limit for textInput
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/01/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:stackLayout>
    <uix:spacer height="10"/>

    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="COMPLIANCE_HOME_INST_TEXT@hostPatchResourceBundle"
          styleClass="OraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height="10"/>

    <uix:tableLayout cellSpacing="4" width="100%">
      <uix:rowLayout>

        <%--cell containing Pie chart--%>
        <uix:cellFormat width="40%" rowSpan="2" vAlign="top">
          <uix:contentContainer
            textBinding="STATUS@commonResourceBundle"
            background="light"
            width="100%">

            <%--Patchable Linux Groups and Hosts--%>
            <uix:labeledFieldLayout 
              labelWidth="45%">
              <uix:contents>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="PATCHABLE_LINUX_GROUPS@hostPatchResourceBundle">
                </uix:styledText>
                <oem:license>
                  <uix:styledText
                    textBinding="numHostPatchGroups@complianceHomeBean@servletRequest"
                    destinationBinding="complianceAllGroupsDest@complianceHomeBean@servletRequest">
                  </uix:styledText>
                </oem:license>
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="PATCHABLE_LINUX_HOSTS@hostPatchResourceBundle">
                </uix:styledText>
                <oem:license> 
                  <uix:styledText
                    textBinding="numHostPatchHosts@complianceHomeBean@servletRequest"
                    destinationBinding="complianceAllHostsDest@complianceHomeBean@servletRequest">
                  </uix:styledText>
                </oem:license>
              </uix:contents>
            </uix:labeledFieldLayout>

            <%--Pie chart--%>
            <oem:chart
              chartType="pieChart"
              width="380"
              height="160"
              shortDescBinding="COMPLIANCE_SUMMARY@hostPatchResourceBundle"
              pieValuesInLegend="value"
              showSlicePercentLabels="true"
              pieSliceColorsBinding="pieChartColors@complianceHomeBean@servletRequest"
              backgroundColorBinding="pieChartBackgroundColor@complianceHomeBean@servletRequest"
              hideZeroSlices="true">

              <oem:boundChartDataSource
                chartDataSourceBinding="pieChartData@complianceHomeBean@servletRequest"/>

              <oem:imageMap
                imageMapItemsBinding="pieChartImageMap@complianceHomeBean@servletRequest"/>

                <oem:chartColumn
                  isKey="true"
                  displayLabel=""
                  sourceIndex="0"/>

                <oem:chartColumn
                  displayLabel=""
                  sourceIndex="1"/>
            </oem:chart>

          </uix:contentContainer>
        </uix:cellFormat>

        <%--cell containing Search and Job status--%>
        <uix:cellFormat vAlign="top">

          <%--Search content container--%>
          <uix:rowLayout width="100%">
            <uix:cellFormat>
              <uix:contentContainer
                textBinding="SEARCH@commonResourceBundle"
                background="light"
                width="100%">

                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:messageChoice
                      name="searchChoice"
                      promptBinding="SEARCH@commonResourceBundle"
                      shortDescBinding="SEARCH@commonResourceBundle">
                      <uix:contents
                      childDataBinding="searchList@complianceHomeBean@servletRequest">
                      <uix:option
                        textBinding="searchOption"
                        valueBinding="searchOptionVal"/>
                      </uix:contents>
                    </uix:messageChoice>
                  </uix:cellFormat>

                  <uix:spacer width="4"/>

                  <uix:cellFormat>
                    <uix:textInput
                      name="searchInput"
                      maximumLength="255"
                      shortDescBinding="SEARCH@commonResourceBundle"
                      columns="25"/>
                  </uix:cellFormat>
                  <uix:spacer width="4"/>
                  <uix:cellFormat>
               
                      <uix:submitButton
                          name="event"
                          value="search"
                          formNameBinding="formName@servletRequest"
                          textBinding="GO@commonResourceBundle"/>
                 
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:contentContainer>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:spacer height="5"/>
          </uix:rowLayout>

          <%--job Status content container--%>
          <uix:rowLayout width="100%">
            <uix:cellFormat>
              <uix:contentContainer
                textBinding="JOB_STATUS@hostPatchResourceBundle"
                background="light"
                width="100%">

                <%--
                  - ER-4046568 Add a table to show the status of all
                  - HostPatching jobs
                  --%>

                <uix:table
                  width="100%"
                  name="jobsStatusTable"
                  summaryBinding="JOBS_STATUS_TABLE_SUMMARY@hostPatchResourceBundle"
                  formSubmitted="true"
                  tableDataBinding="rows@complianceHomeBean@servletRequest"
                  columnHeaderDataBinding="colHeaders@complianceHomeBean@servletRequest">

                  <uix:tableFormat tableBanding="rowBanding"/>

                  <uix:columnHeaderStamp>
                    <uix:sortableHeader
                      textBinding="text">
                    </uix:sortableHeader>
                  </uix:columnHeaderStamp>

                  <uix:styledText
                    textBinding="jobType">
                  </uix:styledText>

                  <uix:column>
                    <uix:columnFormat
                      width="25%"
                      columnDataFormat="iconButtonFormat"/>
                    <uix:flowLayout>
                      <uix:separator>
                        <uix:spacer width="10"/>
                      </uix:separator>
                      <uix:contents>
                        <uix:image
                          sourceBinding="probExeImg"
                          destinationBinding="probExeDest"
                          shortDescBinding="probExeDesc"/>
                        <uix:styledText
                          textBinding="numProbExe"
                          destinationBinding="probExeDest">
                        </uix:styledText>
                      </uix:contents>
                    </uix:flowLayout>
                  </uix:column>

                  <uix:column>
                    <uix:columnFormat
                      width="25%"
                      columnDataFormat="iconButtonFormat"/>
                    <uix:flowLayout>
                      <uix:separator>
                        <uix:spacer width="10"/>
                      </uix:separator>
                      <uix:contents>
                        <uix:image
                          sourceBinding="susExeImg"
                          destinationBinding="susExeDest"
                          shortDescBinding="susExeDesc"/>
                        <uix:styledText
                          textBinding="numSusExe"
                          destinationBinding="susExeDest">
                        </uix:styledText>
                      </uix:contents>
                    </uix:flowLayout>
                  </uix:column>

                </uix:table>

              </uix:contentContainer>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:cellFormat>

      </uix:rowLayout>
    </uix:tableLayout>

    <uix:header textBinding="RELATED_LINKS@hostPatchResourceBundle">
      <uix:tableLayout>
        <uix:rowLayout>
          <uix:link
            textBinding="EMERGENCY_PATCHING@hostPatchResourceBundle"
            destinationBinding="emergencyPatchWizDest@complianceHomeBean@servletRequest">
          </uix:link>
        </uix:rowLayout>

        <uix:rowLayout>
          <oem:license>
            <uix:link
              textBinding="COMPLIANCE_HISTORY@hostPatchResourceBundle"
              destinationBinding="complianceHistoryDest@complianceHomeBean@servletRequest">
            </uix:link>
          </oem:license>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:link
            textBinding="UNDO_PATCHING@hostPatchResourceBundle"
            destinationBinding="undoPatchingWizDest@complianceHomeBean@servletRequest">
          </uix:link>
        </uix:rowLayout>

      </uix:tableLayout>

    </uix:header>

    <uix:spacer height="10"/>
  </uix:stackLayout>
  
</uix:buildTree>

<%@ include file="template.jspf" %>
