<%--
  - FILE
  -   complianceHost.jsp
  -
  - DESCRIPTION
  -   Page showing the compliance information of a particular Host.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda 09/12/07 - remove Emergency patching button
  -   somukher 08/14/07 - ADA bug
  -   aloganda 08/08/07 - Remove host level emergency patching
  -   tasingh  07/26/07 - Bug-6279942 change emergency patching link to button
  -   aloganda 06/09/07 - ULN, add link to emergency patching page
  -   hmodawel 03/06/06 - fix compilation 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  05/24/05 - Bug-4277205 Use icons for needs reboot, use new 
  -                       icons for status col. 
  -   tasingh  03/27/05 - UI review bug fixes 
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI 
  -                       guidelines 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  11/03/04 - Add Version columnm in the table. 
  -   tasingh  10/06/04 - Minor fixes
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  09/02/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout cellSpacing="8" width="100%">

    <uix:rowLayout>
      <uix:cellFormat columnSpan="2">
        <uix:styledText
          textBinding="COMPLIANCE_HOST_INST_TEXT@hostPatchResourceBundle"
          styleClass="OraInstructionText">
        </uix:styledText>
      </uix:cellFormat>
    </uix:rowLayout>

    <uix:rowLayout>

      <%--cell containing table--%>
      <uix:cellFormat width="60%" vAlign="top">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="NON_COMPLIANT_PACKAGES@hostPatchResourceBundle"
            styleClass="OraTableTitle"/>
        </uix:rowLayout>
      </uix:tableLayout>
        <%--
          - This table uses partial renderring mode. So id attribute
          - is must. Also partial renderring requires "/enablePPR.jspf"
          - to be included, which is inculded in the template.jspf
        --%>
        <uix:table
          width="100%"
          name="complianceHostTable"
          id="complianceHostTableID"
          summaryBinding="COMPLIANCE_HOST_SUMMARY@hostPatchResourceBundle"
          partialRenderMode="self"
          formSubmitted="true"
          alternateTextBinding="alternateText@complianceHostBean@servletRequest"
          tableDataBinding="rows@complianceHostBean@servletRequest"
          valueBinding="currentValue@complianceHostBean@servletRequest"
          minValueBinding="minValue@complianceHostBean@servletRequest"
          blockSizeBinding="blockSize@complianceHostBean@servletRequest"
          maxValueBinding="maxValue@complianceHostBean@servletRequest"
          columnHeaderDataBinding="colHeaders@complianceHostBean@servletRequest">

          <uix:tableFormat tableBanding="rowBanding"/>

          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"
              sortableBinding="sortable">
            </uix:sortableHeader>
          </uix:columnHeaderStamp>

          <uix:styledText
            textBinding="package">
          </uix:styledText>

          <uix:styledText
            textBinding="version">
          </uix:styledText>

          <uix:column>
            <uix:columnFormat
              columnDataFormat="iconButtonFormat"/>
            <uix:image
              sourceBinding="statusImgSrc"
              shortDescBinding="status">
            </uix:image>
          </uix:column>

          <uix:column>
            <uix:columnFormat
              columnDataFormat="iconButtonFormat"/>
            <uix:image
              sourceBinding="needsRebootImgSrc"
              shortDescBinding="needsReboot">
            </uix:image>
          </uix:column>

        </uix:table>
      </uix:cellFormat>

      <%--cell containing summary pie chart--%>
      <uix:cellFormat vAlign="top">
        <uix:contentContainer
          textBinding="SUMMARY@hostPatchResourceBundle"
          background="light"
          width="100%">

          <uix:tableLayout> 
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="TOTAL_PACKAGES@hostPatchResourceBundle">
                </uix:styledText>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left">
                <uix:styledText
                  styleClass="OraDataText"
                  textBinding="numTotalPkgs@hostSummary@complianceHostBean@servletRequest">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout renderedBinding="render@hostSummary@complianceHostBean@servletRequest">
              <uix:cellFormat hAlign="right">
                <uix:styledText
                  styleClass="OraFieldText"
                  textBinding="NEEDS_REBOOT@hostPatchResourceBundle">
                </uix:styledText>
              </uix:cellFormat>
              <uix:spacer width="8"/>
              <uix:cellFormat hAlign="left">
                <uix:styledText
                  styleClass="OraDataText"
                textBinding="needsReboot@hostSummary@complianceHostBean@servletRequest">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <oem:chart
            chartType="pieChart"
            width="380"
            height="160"
            shortDescBinding="COMPLIANCE_SUMMARY@hostPatchResourceBundle"
            pieValuesInLegend="value"
            showSlicePercentLabels="true"
            pieSliceColorsBinding="pieChartColors@complianceHostBean@servletRequest"
            backgroundColorBinding="pieChartBackgroundColor@complianceHostBean@servletRequest"
            hideZeroSlices="true">

            <oem:boundChartDataSource
              chartDataSourceBinding="pieChartData@complianceHostBean@servletRequest"/>

            <oem:chartColumn
              isKey="true"
              displayLabel=""
              sourceIndex="0"/>

            <oem:chartColumn
              displayLabel=""
              sourceIndex="1"/>
          </oem:chart>

        </uix:contentContainer>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>
  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
