<%--
  - FILE
  -   ePatchSelHosts.jsp
  -
  - DESCRIPTION
  -   The "Emergency Patching: Select Hosts" page.
  -   It provides a hGrid of Groups and hosts with multiple selection to
  -   select the hosts for immediate updation.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  04/12/05 - UI review bug fixes
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  02/10/05 - Add support for partial renderrring
  -   tasingh  12/28/04 - ER-4046568 Add jobs information text 
  -   tasingh  10/20/04 - 
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="SELECT_HOSTS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <%--to display error message--%>
      <uix:inlineMessage
        messageTypeBinding="msgType@pageData@servletRequest"
        messageBinding="infoMsg@pageData@servletRequest">

        <%--the hGrid--%>
        <uix:hGrid
          id="hostHGrid"
          width="500"
          partialRenderMode="self"
          alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
          summaryBinding="SELECT_HOST_SUMMARY@hostPatchResourceBundle"
          treeDataBinding="hGridData@pageData@servletRequest"
          proxyBinding="hGridProxy@pageData@servletRequest"
          formSubmitted="true">

          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="NAME@commonResourceBundle"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>

          <uix:tableSelection>
            <uix:multipleSelection
              shortDescBinding="SELECT@commonResourceBundle"
              selectedBinding="selected">
            </uix:multipleSelection>
          </uix:tableSelection>
        </uix:hGrid>

      </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
