<%--
  - FILE
  -   ePatchSelPkgs.jsp
  -
  - DESCRIPTION
  -   The "Emergency Patching: Select Packages" page.
  -   It provides a shuttle of packages to be selected for immediate updation.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  04/13/05 - 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  12/28/04 - ER-4046568 Add jobs information text 
  -   tasingh  10/20/04 - 
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:stackLayout>
      <uix:styledText
        textBinding="SELECT_PKGS_TEXT@hostPatchResourceBundle"
        styleClass="oraInstructionText"/>
      <uix:spacer height="10"/>
    </uix:stackLayout>

    <%--to display error message--%>
    <uix:inlineMessage
      messageTypeBinding="msgType@pageData@servletRequest"
      messageBinding="infoMsg@pageData@servletRequest">

        <%--package selection shuttle--%>
        <uix:shuttle
          name="shuttlePkgSel"
          reorderable="false"
          leadingHeaderBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle"
          trailingHeaderBinding="SELECTED_PACKAGES@hostPatchResourceBundle"
          size="10">

          <uix:leading>
            <uix:list
              name="availPkgs"
              multiple="true"
              shortDescBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle">
              <uix:contents childDataBinding="availPkgs@stepsData@servletRequest">
                <uix:option textBinding="pkgName"/>
              </uix:contents>
            </uix:list>
          </uix:leading>

          <uix:trailing>
            <uix:list
              name="selPkgs"
              multiple="true"
              shortDescBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
              <uix:contents childDataBinding="selPkgs@stepsData@servletRequest">
                <uix:option textBinding="pkgName"/>
              </uix:contents>
            </uix:list>
          </uix:trailing>
        </uix:shuttle>

      </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
