<%--
  - FILE
  -  enfCompliancePkgs .jsp
  -
  - DESCRIPTION
  -   The "Enforce Compliance with Emergency Patching: Select Packages" page.
  -   It provides an Hgrid to select the hosts and the corresponding pkgs
  -
  - MODIFIED  (MM/DD/YY)
  -   somukher  08/14/07 - 
  -   aloganda  08/02/07 - bug-6271281, provision up2date to host targets
  -   aloganda  06/21/07 - Modify page text
  -   aloganda  06/18/07 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">
    
     <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="SELECT_HOSTS_PKGS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <%--to display error message--%>
      <uix:inlineMessage
        messageTypeBinding="msgType@pageData@servletRequest"
        messageBinding="infoMsg@pageData@servletRequest">
    
	<%--the hGrid--%>
        <uix:hGrid
          id="hostHGrid"
          width="500"
          partialRenderMode="self"
          alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
          summaryBinding="SELECT_HOST_SUMMARY@hostPatchResourceBundle"
          treeDataBinding="hGridData@pageData@servletRequest"
          proxyBinding="hGridProxy@pageData@servletRequest"
          formSubmitted="true">

          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="NAME@commonResourceBundle"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>

          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="HOST_VER@hostPatchResourceBundle"/>
            </uix:columnHeader>
            <uix:styledText textBinding="version"/>
          </uix:column>

          <uix:column>
            <uix:columnHeader>
              <uix:styledText textBinding="REPOS_VER@hostPatchResourceBundle"/>
            </uix:columnHeader>
            <uix:styledText textBinding="reposVersion"/>
          </uix:column>

          <uix:tableSelection>
            <uix:multipleSelection
              shortDesc="Select"
              selectedBinding="selected"
	      disabledBinding="disabled">
            </uix:multipleSelection>
          </uix:tableSelection>
        </uix:hGrid>

	 </uix:inlineMessage>
   </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
