<%--
  - FILE
  -   enfComplianceReview.jsp
  -
  - DESCRIPTION
  -   The "Enforce Compliance by Emergency Patching: Review" page.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda  06/21/07 - Change selected hosts and packages text
  -   aloganda  06/18/07 - created
  -
  - SINCE
  -   10.2
  --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

    <%--<uix:stackLayout>
      <uix:styledText
        textBinding="printMe@stepsData@servletRequest"
        styleClass="oraInstructionText"/>
      <uix:spacer height="10"/>
    </uix:stackLayout> --%>
    
    <uix:header textBinding="SELECTED_HOSTS_PACKAGES@hostPatchResourceBundle">
    <uix:hGrid
          id="hostHGrid"
          width="500"
          partialRenderMode="self"
          alternateTextBinding="MSG_NO_GROUPS_FOUND@hostPatchResourceBundle"
          summaryBinding="SELECT_HOST_SUMMARY@hostPatchResourceBundle"
          treeDataBinding="hGridData@pageData@servletRequest"
          proxyBinding="hGridProxy@pageData@servletRequest"
          formSubmitted="true">

          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="NAME@commonResourceBundle"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>

        </uix:hGrid>
    </uix:header>

    <uix:spacer height="10"/>
    
    <%--Credentials Type--%>
      <uix:header textBinding="CREDENTIALS@hostPatchResourceBundle">
        <uix:switcher childNameBinding="credsType@pageData@servletRequest">

          <uix:case name="prefCreds">
            <uix:rowLayout>
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
                styleClass="OraPromptText">
              </uix:styledText>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="credsTypeText@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:rowLayout>
          </uix:case>

          <uix:case name="overrideCreds">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:styledText
                  textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
                <uix:spacer width="5"/>
                <uix:styledText
                  textBinding="credsTypeText@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:rowLayout>

              <uix:switcher childNameBinding="overridenCredType@pageData@servletRequest">

                <uix:case name="allHosts">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText
                        textBinding="USERNAME@hostPatchResourceBundle"
                        styleClass="OraPromptText">
                      </uix:styledText>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      textBinding="username@stepsData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:rowLayout>
                </uix:case>

                <uix:case name="eachHost">
                  <uix:table
                    width="500"
                    name="setCred"
                    id="setCredID"
                    summaryBinding="OVERRIDDEN_PREF_CREDS_EACH_HOST@hostPatchResourceBundle"
                    partialRenderMode="self"
                    formSubmitted="true"
                    tableDataBinding="setCred@stepsData@servletRequest"
                    columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                    valueBinding="setCredCurrValue@pageData@servletRequest"
                    minValueBinding="setCredMinValue@pageData@servletRequest"
                    blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                    maxValueBinding="setCredMaxValue@pageData@servletRequest">


                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:sortableHeader
                        textBinding="text"
                        sortableBinding="sortable">
                      </uix:sortableHeader>
                    </uix:columnHeaderStamp>

                    <uix:styledText
                      textBinding="targetName"
                      shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
                    </uix:styledText>

                    <uix:styledText
                      textBinding="username">
                    </uix:styledText>

                  </uix:table>
                </uix:case>

              </uix:switcher>
            </uix:tableLayout>

          </uix:case>

        </uix:switcher>

      </uix:header>

      <uix:spacer height="10"/>

      <%--Patching Scripts Information--%>
      <uix:header textBinding="PATCHING_SCRIPTS@hostPatchResourceBundle">

        <%--Pre-Patching Script--%>
        <uix:header textBinding="PRE_PATCHING_SCRIPT@hostPatchResourceBundle">

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="PRE_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="applyPreScript@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="preScriptLoc@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="PRE_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="applyPreAsRoot@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

          </uix:tableLayout>
        </uix:header>

       
        <uix:spacer height="10"/>
              
        
        <%--Post-Patching Script--%>
        <uix:header textBinding="POST_PATCHING_SCRIPT@hostPatchResourceBundle">

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="POST_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="applyPostScript@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="postScriptLoc@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="POST_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="applyPostAsRoot@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

          </uix:tableLayout>
        </uix:header>

        

      </uix:header>

 
      <uix:spacer height="10"/>  
      
    
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
  
