<%--
  - FILE
  -   groupProperties.jsp
  -
  - DESCRIPTION
  -   Page to get basic group properties (name, maturity, hosts) from the user
  -   for the Add/Edit Group Trian Wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda 08/27/07 - bug-6353866
  -   ppalleti 12/06/05 - Backport ppalleti_hp_bugs from main 
  -   ppalleti 11/22/05 - bug-4686991 Creating group failed for invalid 
  -                       maturity level 
  -   tasingh  04/05/05 - UI review bugs 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  12/27/04 - ER-4046568 Add jobs information text
  -   tasingh  10/04/04 - set max input limit for messageTextInput
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

   <uix:stackLayout>
     <uix:styledText
       textBinding="SPECIFY_NAME_AND_MATURITY@hostPatchResourceBundle"
       styleClass="OraInstructionText">
     </uix:styledText>

     <uix:spacer height="10"/>
   </uix:stackLayout>

    <uix:switcher childNameBinding="action@stepsData@servletRequest">
      <uix:case name="createGroup">
        <uix:labeledFieldLayout
          labelWidth="0%" fieldWidth="100%" >

          <%--Group name field--%>
          <uix:messageTextInput
            name="groupName"
            promptBinding="NAME@commonResourceBundle"
            textBinding="groupName@stepsData@servletRequest"
            maximumLength="255"
            required="uiOnly"
            messageTypeBinding="groupNameError@pageData@servletRequest"
            messageBinding="groupNameMsg@pageData@servletRequest"/>

          <%--Maturity dropdown--%>
          <uix:messageChoice
            name="maturity"
            promptBinding="MATURITY@hostPatchResourceBundle"
            shortDescBinding="GROUP_MATURITY@hostPatchResourceBundle"
            selectedValueBinding="maturitySelValue@stepsData@servletRequest">
            <uix:contents
              childDataBinding="maturityList@pageData@servletRequest">
              <uix:option 
		textBinding="maturity"
		valueBinding="maturityVal"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:labeledFieldLayout>
      </uix:case>

      <uix:case name="editGroup">
        <uix:labeledFieldLayout width="0"
          labelWidth="0" fieldWidth="0" >

          <%--Group name field--%>
          <uix:styledText
            textBinding="NAME@commonResourceBundle"
            styleClass="OraPromptText"/>
          <uix:styledText
            textBinding="groupName@stepsData@servletRequest"
            styleClass="OraDataText"/>

          <%--Maturity dropdown--%>
          <uix:messageChoice
            name="maturity"
            promptBinding="MATURITY@hostPatchResourceBundle"
            shortDescBinding="GROUP_MATURITY@hostPatchResourceBundle"
            selectedValueBinding="maturitySelValue@stepsData@servletRequest">
            <uix:contents
              childDataBinding="maturityList@pageData@servletRequest">
              <uix:option textBinding="maturity" valueBinding="maturityVal"/>
            </uix:contents>
          </uix:messageChoice>
        </uix:labeledFieldLayout>
      </uix:case>
    </uix:switcher>

    <uix:spacer height="10"/>

    <%-- ER-4046568--%>
    <uix:header
      textBinding="LINUX_HOSTS@hostPatchResourceBundle"
      size="1">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="SELECT_LINUX_HOSTS_INST_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <uix:inlineMessage
        messageTypeBinding="selTargetsError@pageData@servletRequest"
        messageBinding="selTargetsMsg@pageData@servletRequest">

        <%--target selection shuttle--%>
        <uix:shuttle
          name="targetSelShuttle"
          reorderable="false"
          leadingHeaderBinding="AVAILABLE_TARGETS@hostPatchResourceBundle"
          trailingHeaderBinding="SELECTED_TARGETS@hostPatchResourceBundle"
          size="10">

          <uix:leading>
            <uix:list
              name="availTargets"
              multiple="true"
              shortDescBinding="AVAILABLE_TARGETS@hostPatchResourceBundle">
              <uix:contents childDataBinding="availTargets@stepsData@servletRequest">
                <uix:option textBinding="targetName"/>
              </uix:contents>
            </uix:list>
          </uix:leading>

          <uix:trailing>
            <uix:list
              name="selTargets"
              multiple="true"
              shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
              <uix:contents childDataBinding="selTargets@stepsData@servletRequest">
                <uix:option textBinding="targetName"/>
              </uix:contents>
            </uix:list>
          </uix:trailing>
        </uix:shuttle>
      </uix:inlineMessage>
    </uix:header>

  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
