<%--
  - FILE
  -   groupRepositories.jsp
  -
  - DESCRIPTION
  -   Page to get package repositories from the user for the
  -   Add/Edit Group Train Wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda 06/20/07 - ULN, modify text at automatically update hosts check
  -                       box
  -   aloganda 06/06/07 - ULN project, for compliance only modification
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  06/17/05 - Use PPR to render dependent elements 
  -   tasingh  04/06/05 - UI review bug fixes 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  12/27/04 - ER-4046568 Add jobs information text 
  -   tasingh  10/19/04 - Add tip for Need-Reboot packages 
  -   tasingh  10/04/04 - set max input limit for messgeTextInput
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <%-- Package Repositories URLs header --%>
    <uix:header textBinding="PACKAGE_REPOSITORIES@hostPatchResourceBundle">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="PKG_REP_URL_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>
    
      <%--Error messageBox for repURL Table--%>
      <uix:inlineMessage
        messageTypeBinding="repURLTableError@pageData@servletRequest"
        messageBinding="repURLTableMsg@pageData@servletRequest">

        <%--Package Repository table--%>
        <uix:table
          width="100%"
          name="repURLTable"
          id="repURLTableID"
          summaryBinding="GROUP_REP_TABLE_SUMMARY@hostPatchResourceBundle"
          partialRenderMode="self"
          formSubmitted="true"
          tableDataBinding="repURLTable@stepsData@servletRequest"
          columnHeaderDataBinding="repURLColHeader@stepsData@servletRequest">

          <uix:columnHeaderStamp>
            <uix:text textBinding="text"/>
          </uix:columnHeaderStamp>

          <uix:columnFooter>
            <uix:addTableRow textBinding="ADD_ANOTHER_ROW@hostPatchResourceBundle"/>
          </uix:columnFooter>

          <uix:column>
            <uix:columnFormat
              cellNoWrapFormat="true"
              columnDataFormat="numberFormat"/>
            <uix:styledText
              textBinding="priority">
            </uix:styledText>
          </uix:column>

          <%-- repURL input box is placed inside tableLayout, so that the input boxes
            -- are properly aligned, when error message is to be displayed
            --%>
          <uix:tableLayout width="100%">
            <uix:rowLayout hAlign="right">
              <uix:messageTextInput name="repURL"
                textBinding="repURL"
                shortDescBinding="PKG_REP_URL@hostPatchResourceBundle"
                columns="80"
                maximumLength="255"
                messageTypeBinding="msgType"
                messageBinding="repURLMsg"/>
            </uix:rowLayout>
          </uix:tableLayout>

        </uix:table>
      </uix:inlineMessage>

    </uix:header>

    <uix:spacer height="10"/>
    
    <%--Package job information--%>
    <uix:header textBinding="UPD_HOSTS@hostPatchResourceBundle">
    
      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="AUTO_UPD_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>
      
      <uix:spacer height="10"/>
      
      <uix:tableLayout>
        <uix:rowLayout>
	<uix:cellFormat width="10%"/>
          <uix:cellFormat>
          <uix:checkBox
              name="complChkBx"
              textBinding="AUTO_UPD_CHKBOX@hostPatchResourceBundle"
              checkedBinding="complChkBx@stepsData@servletRequest"
              primaryClientActionBinding="onChangeComplChkBx@pageData@servletRequest"/>
        </uix:cellFormat>
	</uix:rowLayout>
      </uix:tableLayout>
      
      
    </uix:header>
    
    <uix:spacer height="10"/>

    <%--Rogue packages information--%>
    <uix:header textBinding="PACKAGE_COMPLIANCE@hostPatchResourceBundle">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="PKG_COMPLIANCE_CFG_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <uix:tableLayout cellSpacing="2">
        <uix:rowLayout>
          <uix:cellFormat columnSpan="2">
            <uix:checkBox
              name="roguePkgChkBx"
              textBinding="ROGUE_PKG_CHK_BOX_TEXT@hostPatchResourceBundle"
              checkedBinding="roguePkgChkBx@stepsData@servletRequest"
              primaryClientActionBinding="onChangeRoguePkgChkBx@pageData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:messageTextInput
              id="ignoreUnknownPkgListID"
              name="ignoreUnknownPkgList"
              maximumLength="255"
              columns="70"
              vAlign="center"
              disabledBinding="isRoguePkgUnChkd@stepsData@servletRequest"
              promptBinding="IGNORE_UNKNOWN_PKGS_TEXT@hostPatchResourceBundle"
              textBinding="ignoreUnknownPkgList@stepsData@servletRequest">
            </uix:messageTextInput>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:checkBox
              id="higherVerChkBxID"
              name="higherVerChkBx"
              textBinding="HIGHER_VERSION_CHK_BOX_TEXT@hostPatchResourceBundle"
              checkedBinding="higherVerChkBx@stepsData@servletRequest"
              disabledBinding="isRoguePkgUnChkd@stepsData@servletRequest"
              primaryClientActionBinding="onChangeHigherVerChkBx@pageData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat hAlign="right">
            <uix:messageTextInput
              id="strictVerChkPkgListID"
              name="strictVerChkPkgList"
              maximumLength="255"
              columns="60"
              disabledBinding="isHigherVerUnChkd@stepsData@servletRequest"
              vAlign="center"
              promptBinding="STRICT_CHECKING_TEXT@hostPatchResourceBundle"
              textBinding="strictVerChkPkgList@stepsData@servletRequest">
            </uix:messageTextInput>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>

    <%--NeedReboot packages--%>
    <uix:header textBinding="PKGS_NEEDING_REBOOT@hostPatchResourceBundle">

      <uix:stackLayout>
        <uix:styledText
          textBinding="NEED_REBOOT_PKGS_TEXT@hostPatchResourceBundle"
          styleClass="OraInstructionText"/>
        <uix:spacer height="10"/>
      </uix:stackLayout>

      <uix:messageTextInput
        name="needRebootPkgs"
        textBinding="needRebootPkgs@stepsData@servletRequest"
        maximumLength="255"
        columns="65"
        vAlign="center"
        promptBinding="PKGS_NEEDING_REBOOT@hostPatchResourceBundle">
      </uix:messageTextInput>

      <uix:spacer height="10"/>

    </uix:header>

    <uix:stackLayout>
      <uix:tip>
        <uix:text textBinding="COMMA_SEPARATED_TIP@hostPatchResourceBundle"/>
      </uix:tip/>
      <uix:tip>
        <uix:text textBinding="REGULAR_EXPRESSION_TIP@hostPatchResourceBundle"/>
      </uix:tip/>
    </uix:stackLayout>

  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
