<%--
  - FILE
  -   groupReview.jsp
  -
  - DESCRIPTION
  -   Review page for the Add/Edit Group Train Wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   aloganda 06/07/07 - ULN, disable credentials, sechdule, scripts section
  -                       for Compliance only job
  -   ppalleti 12/06/05 - Backport ppalleti_hp_bugs from main 
  -   ppalleti 11/22/05 - Bug - 4597956 Missing or Incorrect Resource IDs for 
  -                       used Text 
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   achugh   05/05/05 - Add section for patching scripts. 
  -   tasingh  04/05/05 - UI review bug fixes 
  -   tasingh  03/18/05 - Bug-4239819 Show the selected credentials option
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  12/28/04 -
  -   tasingh  11/03/04 - Change Selected Repostories to Selected Package
  -                       Repostories
  -   tasingh  10/01/04 - Get needRebootPkg list from page storage rather than
  -                       steps storage
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <%--Group Properties--%>
      <uix:header textBinding="PROPERTIES@commonResourceBundle">

        <%--GroupName and Maturity--%>
        <uix:tableLayout>
          <uix:rowLayout>
            <uix:styledText
              textBinding="NAME@commonResourceBundle"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:styledText
              textBinding="groupName@stepsData@servletRequest"
              styleClass="OraDataText">
            </uix:styledText>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:styledText
              textBinding="MATURITY@hostPatchResourceBundle"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:styledText
              textBinding="maturitySelValue@stepsData@servletRequest"
              styleClass="OraDataText">
            </uix:styledText>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:spacer height="5"/>

        <%--Selected Targets table title--%>
        <uix:tableLayout>
          <uix:rowLayout>
            <uix:styledText
              textBinding="SELECTED_LINUX_HOSTS@hostPatchResourceBundle"
              styleClass="OraTableTitle"/>
          </uix:rowLayout>

          <%--Selected Targets table--%>
          <uix:rowLayout>
            <uix:table
              width="500"
              name="selTargets"
              id="selTargetsID"
              summaryBinding="SELECTED_HOSTS_TABLE@hostPatchResourceBundle"
              partialRenderMode="self"
              formSubmitted="true"
              tableDataBinding="selTargets@stepsData@servletRequest"
              columnHeaderDataBinding="selTargetsColHeader@pageData@servletRequest"
              valueBinding="selTargetsCurrValue@pageData@servletRequest"
              minValueBinding="selTargetsMinValue@pageData@servletRequest"
              blockSizeBinding="selTargetsBlockSize@pageData@servletRequest"
              maxValueBinding="selTargetsMaxValue@pageData@servletRequest">

              <uix:tableFormat tableBanding="rowBanding"/>

              <uix:columnHeaderStamp>
                <uix:sortableHeader
                  textBinding="text"
                  sortableBinding="sortable">
                </uix:sortableHeader>
              </uix:columnHeaderStamp>

              <uix:styledText
                textBinding="targetName"
                shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
              </uix:styledText>
            </uix:table>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>

      <uix:spacer height="10"/>

      <%--Repository Information--%>
      <uix:header textBinding="PACKAGE_REPOSITORIES@hostPatchResourceBundle">

        <%--compliance parameter--%>
        <uix:header textBinding="PACKAGE_COMPLIANCE@hostPatchResourceBundle">

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="PKGS_NEEDING_REBOOT@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="needRebootPkgs@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="CONSIDER_ROGUE_PACKAGES@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="considerRoguePkgs@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="isRoguePkgUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="PACKAGES_TO_BE_IGNORED@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="ignoreUnknownPkgList@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isRoguePkgUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="MARK_HIGHER_VER_TEXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="markHigherVer@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isHigherVerUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="PACKAGES_TO_BE_STRICTLY_CHECKED@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="strictVerChkPkgList@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>
          </uix:tableLayout>
        </uix:header>

        <uix:spacer height="10"/>

        <%--Repository table header--%>
        <uix:header textBinding="PACKAGE_REPOSITORIES@hostPatchResourceBundle">

          <%--Repository table--%>
          <uix:table
            width="500"
            name="repURLTable"
            id="repURLTableID"
            summaryBinding="PACKAGE_REP_TABLE@hostPatchResourceBundle"
            partialRenderMode="self"
            formSubmitted="true"
            tableDataBinding="repURLTable@stepsData@servletRequest"
            columnHeaderDataBinding="repURLColHeader@pageData@servletRequest"
            valueBinding="repURLCurrValue@pageData@servletRequest"
            minValueBinding="repURLMinValue@pageData@servletRequest"
            blockSizeBinding="repURLBlockSize@pageData@servletRequest"
            maxValueBinding="repURLMaxValue@pageData@servletRequest">
            <uix:tableFormat tableBanding="rowBanding"/>

            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"
                sortableBinding="sortable">
              </uix:sortableHeader>
            </uix:columnHeaderStamp>

            <uix:column>
              <uix:columnFormat
                width="60"
                cellNoWrapFormat="true"
                columnDataFormat="numberFormat"/>
              <uix:styledText
                textBinding="priority">
              </uix:styledText>
            </uix:column>

            <uix:styledText
              textBinding="repURL"
              shortDescBinding="PKG_REP_URL@hostPatchResourceBundle">
            </uix:styledText>
          </uix:table>
        </uix:header>
      </uix:header>

      <uix:spacer height="10"/>

      <%--Credentials Type
      <uix:header  textBinding="CREDENTIALS@hostPatchResourceBundle">--%>
      <uix:header  textBinding="CREDENTIALS@hostPatchResourceBundle">
        <uix:switcher childNameBinding="credsType@pageData@servletRequest">

          <uix:case name="prefCreds">
            <uix:rowLayout>
              <uix:styledText
                textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
                styleClass="OraPromptText">
              </uix:styledText>
              <uix:spacer width="5"/>
              <uix:styledText
                textBinding="credsTypeText@pageData@servletRequest"
                styleClass="OraDataText">
              </uix:styledText>
            </uix:rowLayout>
          </uix:case>

          <uix:case name="overrideCreds">
            <uix:tableLayout>
              <uix:rowLayout>
                <uix:styledText
                  textBinding="CREDENTIALS_TYPE@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
                <uix:spacer width="5"/>
                <uix:styledText
                  textBinding="credsTypeText@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:rowLayout>

              <uix:switcher childNameBinding="overridenCredType@pageData@servletRequest">

                <uix:case name="allHosts">
                  <uix:rowLayout>
                    <uix:cellFormat> 
                      <uix:styledText
                        textBinding="USERNAME@hostPatchResourceBundle"
                        styleClass="OraPromptText">
                      </uix:styledText>
                    </uix:cellFormat>
                    <uix:spacer width="5"/>
                    <uix:styledText
                      textBinding="username@stepsData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:rowLayout>
                </uix:case>

                <uix:case name="eachHost">
                  <uix:table
                    width="500"
                    name="setCred"
                    id="setCredID"
                    summaryBinding="OVERRIDDEN_PREF_CREDS_EACH_HOST@hostPatchResourceBundle"
                    partialRenderMode="self"
                    formSubmitted="true"
                    tableDataBinding="setCred@stepsData@servletRequest"
                    columnHeaderDataBinding="setCredColHeader@stepsData@servletRequest"
                    valueBinding="setCredCurrValue@pageData@servletRequest"
                    minValueBinding="setCredMinValue@pageData@servletRequest"
                    blockSizeBinding="setCredBlockSize@pageData@servletRequest"
                    maxValueBinding="setCredMaxValue@pageData@servletRequest">


                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:columnHeaderStamp>
                      <uix:sortableHeader
                        textBinding="text"
                        sortableBinding="sortable">
                      </uix:sortableHeader>
                    </uix:columnHeaderStamp>

                    <uix:styledText
                      textBinding="targetName"
                      shortDescBinding="SELECTED_TARGETS@hostPatchResourceBundle">
                    </uix:styledText>

                    <uix:styledText
                      textBinding="username">
                    </uix:styledText>
                  </uix:table>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>
      </uix:header>

      <uix:spacer height="10"/>

      <%--Patching Scripts Information--%>
      <uix:header  renderedBinding="renderScripts@stepsData@servletRequest" textBinding="PATCHING_SCRIPTS@hostPatchResourceBundle">

        <%--Pre-Patching Script--%>
        <uix:header textBinding="PRE_PATCHING_SCRIPT@hostPatchResourceBundle">

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="PRE_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="applyPreScript@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="preScriptLoc@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isPreScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="PRE_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="applyPreAsRoot@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

          </uix:tableLayout>
        </uix:header>

       
        <uix:spacer height="10"/>
              
        
        <%--Post-Patching Script--%>
        <uix:header textBinding="POST_PATCHING_SCRIPT@hostPatchResourceBundle">

          <uix:tableLayout>

            <uix:rowLayout>
              <uix:cellFormat>
                <uix:styledText
                  textBinding="POST_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
                  styleClass="OraPromptText">
                </uix:styledText>
              </uix:cellFormat>

              <uix:spacer width="8"/>

              <uix:cellFormat>
                <uix:styledText
                  textBinding="applyPostScript@pageData@servletRequest"
                  styleClass="OraDataText">
                </uix:styledText>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="postScriptLoc@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="isPostScriptUnChkd@stepsData@servletRequest">
              <uix:case name="false">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="POST_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
                      styleClass="OraPromptText">
                    </uix:styledText>
                  </uix:cellFormat>

                  <uix:spacer width="8"/>

                  <uix:cellFormat>
                    <uix:styledText
                      textBinding="applyPostAsRoot@pageData@servletRequest"
                      styleClass="OraDataText">
                    </uix:styledText>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

          </uix:tableLayout>
        </uix:header>

        

      </uix:header>

     

      <uix:spacer height="10"/>

      <%--Update Schedule Information--%>
      <uix:header  renderedBinding="renderScripts@stepsData@servletRequest" textBinding="UPDATE_SCHEDULE@hostPatchResourceBundle">
        <uix:tableLayout>
          <uix:rowLayout vAlign="top">
            <uix:styledText
              textBinding="SCHEDULED@hostPatchResourceBundle"
              styleClass="OraPromptText">
            </uix:styledText>
            <uix:spacer width="5"/>
            <uix:formattedText
              textBinding="scheduleInfo@pageData@servletRequest"
              styleClass="OraDataText">
            </uix:formattedText>
          </uix:rowLayout>
        </uix:tableLayout>
      </uix:header>

    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
