<%--
  - FILE
  -   groupsHome.jsp
  -
  - DESCRIPTION
  -   HostPatch Groups home Page. It shows the groups created for Linux Host
  -   Patching, the package repositories associated with them, their update
  -   schedule etc.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  07/13/05 - ADA Bugs 
  -   tasingh  06/20/05 - Add summary attribute 
  -   tasingh  03/24/05 - UI review bug fixes 
  -   achugh   03/11/05 - Bug-4199708
  -   tasingh  03/16/05 - Make minor changes so as to conform to the UI
  -                       guidelines
  -   tasingh  01/12/05 - Bug-4114707 Pass groupName as form value on form
  -                       submission
  -   tasingh  01/06/05 - ER-4083196 Make first radio button in the table as
  -                       selected by default
  -   achugh   12/29/04 - to add licensing tags
  -   tasingh  12/29/04 - Add column for updater job
  -   tasingh  12/22/04 -
  -   tasingh  10/04/04 - set max limit for messageTextInput
  -   tasingh  09/27/04 - tasingh_hostpatch_ui
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All paage contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:spacer height="10"/>

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        textBinding="GROUPS_HOME_INST_TEXT@hostPatchResourceBundle"
        styleClass="OraInstructionText">
      </uix:styledText>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>

  <%--Search Message Box--%>
  <uix:tableLayout width="100%">
    <uix:rowLayout>
      <uix:cellFormat hAlign="left">
        <uix:messageTextInput
          name="groupRegex"
          promptBinding="SEARCH@commonResourceBundle"
          maximumLength="255"
          textBinding="groupRegex@servletRequest">
          <uix:end>
            <uix:flowLayout>
              <uix:submitButton
                name="event"
                value="search"
                formNameBinding="formName@servletRequest"
                textBinding="GO@commonResourceBundle"/>
            </uix:flowLayout>
          </uix:end>
        </uix:messageTextInput>
      </uix:cellFormat>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:spacer height="10"/>

  <%--
    - This table uses partial renderring mode. So id attribute is must. Also
    - partial renderring requires "/enablePPR.jspf" to be included, which is
    - inculded in the template.jspf
  --%>
  <uix:table
    width="100%"
    name="groupsTable"
    id="groupsTableID"
    summaryBinding="GROUPS_HOME_TABLE_SUMMARY@hostPatchResourceBundle"
    partialRenderMode="self"
    formSubmitted="true"
    alternateTextBinding="MSG_NO_GROUPS_FOUND@hostPatchResourceBundle"
    tableDataBinding="rows@groupsHomeBean@servletRequest"
    valueBinding="currentValue@groupsHomeBean@servletRequest"
    minValueBinding="minValue@groupsHomeBean@servletRequest"
    blockSizeBinding="blockSize@groupsHomeBean@servletRequest"
    maxValueBinding="maxValue@groupsHomeBean@servletRequest"
    columnHeaderDataBinding="colHeaders@groupsHomeBean@servletRequest"
    detailDisclosureBinding="detailsState@groupsHomeBean@servletRequest"
    allDetailsEnabledBinding="allDetailsEnabled@servletRequest">

    <uix:tableActions>
      <uix:submitButton
        name="event"
        value="add"
        formNameBinding="formName@servletRequest"
        textBinding="CREATE@commonResourceBundle"/>
    </uix:tableActions>

    <uix:tableSelection>
      <uix:singleSelection 
        selectedIndex="0"
        shortDescBinding="SELECT@commonResourceBundle"
        selectedIndexBinding="tableSelIdx@servletRequest">

        <uix:submitButton
          name="event"
          value="remove"
          formNameBinding="formName@servletRequest"
          textBinding="DELETE@commonResourceBundle"/>

          <uix:submitButton
            name="event"
            value="configure"
            formNameBinding="formName@servletRequest"
            textBinding="EDIT@commonResourceBundle"/>

      </uix:singleSelection>
    </uix:tableSelection>

    <uix:columnHeaderStamp>
      <uix:sortableHeader
        textBinding="text"
        sortableBinding="sortable">
      </uix:sortableHeader>
    </uix:columnHeaderStamp>

    <uix:styledText
      textBinding="groupName"
      destinationBinding="groupDest">
    </uix:styledText>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numHosts"
        destinationBinding="numHostsDest">
      </uix:styledText>
    </uix:column>

    <uix:styledText
      textBinding="updaterJobName"
      destinationBinding="updaterJobLink">
    </uix:styledText>

    <uix:styledText
      textBinding="maturity">
    </uix:styledText>

    <uix:column>
      <uix:columnFormat
        cellNoWrapFormat="true"
        columnDataFormat="numberFormat"/>
      <uix:styledText
        textBinding="numPkgRepos">
      </uix:styledText>
    </uix:column>

    <%-- Bug-4114707 Pass groupName as form Value on form submission--%>
    <uix:formValue name="groupName" valueBinding="groupName"/>

    <uix:detail>
      <uix:tableLayout width="100%">
        <uix:rowLayout>
          <uix:cellFormat width="50%" vAlign="top">
            <uix:header textBinding="PATCHING_INFORMATION@hostPatchResourceBundle">
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:styledText
                    textBinding="PKGS_NEEDING_REBOOT@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                  <uix:spacer width="5"/>
                  <uix:styledText
                    textBinding="needRebootPkgs"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:styledText
                    textBinding="PACKAGE_REPOSITORIES@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                </uix:rowLayout>
              </uix:tableLayout>
              <uix:bulletedList>
                <uix:contents
                  childDataBinding="repURLList">
                  <uix:styledText
                    textBinding="repURL"
                    styleClass="OraDataText">
                  </uix:styledText>
                </uix:contents>
              </uix:bulletedList>
            </uix:header>
          </uix:cellFormat>

          <uix:cellFormat width="50%" vAlign="top">
            <uix:header textBinding="UPDATE_SCHEDULE@hostPatchResourceBundle">
              <uix:tableLayout>
                <uix:rowLayout vAlign="top">
                  <uix:styledText
                    textBinding="SCHEDULED@hostPatchResourceBundle"
                    styleClass="OraPromptText">
                  </uix:styledText>
                  <uix:spacer width="5"/>
                  <uix:formattedText
                    textBinding="scheduleInfo"
                    styleClass="OraDataText">
                  </uix:formattedText>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:cellFormat>

        </uix:rowLayout>
      </uix:tableLayout>
    </uix:detail>
  </uix:table>

  <uix:spacer height="5"/>

</uix:buildTree>

<%@ include file="template.jspf" %>
