<%--
  - FILE
  -   ulnCfgFilesWizPrePostScripts.jsp
  -
  - DESCRIPTION
  -   Page to get patching scripts from the user for the
  -   Emergency Patching Train Wizard.
  -
  - MODIFIED  (MM/DD/YY)
  -   achugh  04/28/05 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="SCRIPT_TXT@hostPatchResourceBundle"
          styleClass="oraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height="10"/>




    <%--Pre-Patching Script--%>
    <uix:header textBinding="PRE_PATCHING_SCRIPT@hostPatchResourceBundle">


      <uix:spacer height="10"/>

      <uix:tableLayout cellSpacing="2">
        <uix:rowLayout>
          <uix:cellFormat columnSpan="2">
            <uix:checkBox
              name="preScriptChkBx"
              textBinding="PRE_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
              checkedBinding="preScriptChkBx@stepsData@servletRequest"
              primaryClientActionBinding="onChangePreScriptChkBx@pageData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>


        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:messageTextInput
              id="preScriptLocationID"
              name="preScriptLocation"
              maximumLength="255"
              columns="70"
              vAlign="center"
              disabledBinding="isPreScriptUnChkd@stepsData@servletRequest"
              promptBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
              textBinding="preScriptLocation@stepsData@servletRequest">
            </uix:messageTextInput>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:checkBox
              id="applyPreAsRootChkBxID"
              name="applyPreAsRootChkBx"
              textBinding="PRE_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
              checkedBinding="applyPreAsRootChkBx@stepsData@servletRequest"
              disabledBinding="isPreScriptUnChkd@stepsData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>

    <uix:spacer height="10"/>

    <%--Post-Patching Script--%>
    <uix:header textBinding="POST_PATCHING_SCRIPT@hostPatchResourceBundle">


      <uix:spacer height="10"/>

      <uix:tableLayout cellSpacing="2">
        <uix:rowLayout>
          <uix:cellFormat columnSpan="2">
            <uix:checkBox
              name="postScriptChkBx"
              textBinding="POST_SCRIPT_CHK_BOX_TXT@hostPatchResourceBundle"
              checkedBinding="postScriptChkBx@stepsData@servletRequest"
              primaryClientActionBinding="onChangePostScriptChkBx@pageData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>


        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:messageTextInput
              id="postScriptLocationID"
              name="postScriptLocation"
              maximumLength="255"
              columns="70"
              vAlign="center"
              disabledBinding="isPostScriptUnChkd@stepsData@servletRequest"
              promptBinding="SCRIPT_LOCATION_TXT@hostPatchResourceBundle"
              textBinding="postScriptLocation@stepsData@servletRequest">
            </uix:messageTextInput>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat width="5%"/>
          <uix:cellFormat>
            <uix:checkBox
              id="applyPostAsRootChkBxID"
              name="applyPostAsRootChkBx"
              textBinding="POST_SCRIPT_ROOT_CHK_BOX_TXT@hostPatchResourceBundle"
              checkedBinding="applyPostAsRootChkBx@stepsData@servletRequest"
              disabledBinding="isPostScriptUnChkd@stepsData@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
    </uix:header>

    <uix:spacer height="10"/>
    

    <uix:stackLayout>
      <uix:tip>
        <uix:text textBinding="SPECIFY_PATH_TIP@hostPatchResourceBundle"/>
      </uix:tip/>
      <uix:tip>
        <uix:text textBinding="ESCAPE_CHAR_TIP@hostPatchResourceBundle"/>
      </uix:tip/>
    </uix:stackLayout>


    
  </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>

