<%--
  - FILE
  -   ulnCfgFilesWizSelCfgFiles.jsp
  -
  - DESCRIPTION
  -   Page for selecting config files from a channel.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

    <uix:stackLayout>
      <uix:styledText
        textBinding="SELECT_PKGS_TEXT@hostPatchResourceBundle"
        styleClass="oraInstructionText"/>
      <uix:spacer height="10"/>
    </uix:stackLayout>

    <%--to display error message--%>
    <uix:inlineMessage
      messageTypeBinding="msgType@pageData@servletRequest"
      messageBinding="infoMsg@pageData@servletRequest">

        <%--package selection shuttle--%>
        <uix:shuttle
          name="shuttlePkgSel"
          reorderable="false"
          leadingHeaderBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle"
          trailingHeaderBinding="SELECTED_PACKAGES@hostPatchResourceBundle"
          size="10">

          <uix:leading>
            <uix:list
              name="availPkgs"
              multiple="true"
              shortDescBinding="AVAILABLE_PACKAGES@hostPatchResourceBundle">
              <uix:contents childDataBinding="availPkgs@stepsData@servletRequest">
                <uix:option textBinding="pkgName"/>
              </uix:contents>
            </uix:list>
          </uix:leading>

          <uix:trailing>
            <uix:list
              name="selPkgs"
              multiple="true"
              shortDescBinding="SELECTED_PACKAGES@hostPatchResourceBundle">
              <uix:contents childDataBinding="selPkgs@stepsData@servletRequest">
                <uix:option textBinding="pkgName"/>
              </uix:contents>
            </uix:list>
          </uix:trailing>
        </uix:shuttle>

      </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
