<%--
  - FILE
  -   ulnCfgFilesWizSelHosts.jsp
  -
  - DESCRIPTION
  -   The "Emergency Patching: Select Hosts" page.
  -   It provides a hGrid of Groups and hosts with multiple selection to
  -   select the hosts for immediate updation.
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  08/30/04 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--All contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

    <uix:dataScope currentDataBinding="pageData@servletRequest">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="SELECT_HOSTS_TEXT@hostPatchResourceBundle"
            styleClass="oraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:spacer height="10"/>

      <%--to display error message--%>
      <uix:inlineMessage
        messageTypeBinding="msgType@pageData@servletRequest"
        messageBinding="infoMsg@pageData@servletRequest">

        <%--the hGrid--%>
        <uix:hGrid
          id="hostHGrid"
          width="500"
          partialRenderMode="self"
          alternateTextBinding="MSG_NO_HOSTS_FOUND@hostPatchResourceBundle"
          summaryBinding="SELECT_HOST_SUMMARY@hostPatchResourceBundle"
          treeDataBinding="hGridData@pageData@servletRequest"
          proxyBinding="hGridProxy@pageData@servletRequest"
          formSubmitted="true">

          <uix:nodeStamp>
            <uix:column>
              <uix:columnHeader>
                <uix:styledText textBinding="NAME@commonResourceBundle"/>
              </uix:columnHeader>
              <uix:styledText textBinding="text"/>
            </uix:column>
          </uix:nodeStamp>

          <uix:tableSelection>
            <uix:multipleSelection
              shortDescBinding="SELECT@commonResourceBundle"
              selectedBinding="selected">
            </uix:multipleSelection>
          </uix:tableSelection>
        </uix:hGrid>

      </uix:inlineMessage>
    </uix:dataScope>

</uix:buildTree>

<%@ include file="wizTemplate.jspf" %>
