<%--
  - FILE
  -   ulnChannelDetails.jsp
  -
  - DESCRIPTION
  -   Page showing the details of a ULN Channel
  -
  - MODIFIED  (MM/DD/YY)
  -   tasingh  06/15/07 - created
  -
  - SINCE
  -   10.2.0.4
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%--To display the Timestamp--%>
<uix:buildTree nodeID="timestamp" scope="request">
  <%@ include file="timestamp.jspf" %>
</uix:buildTree>

<%--All page contents should be within this tag--%>
<uix:buildTree nodeID="pageContent" scope="request">

  <uix:tableLayout>
    <uix:rowLayout>
      <uix:styledText
        textBinding="ULN_CHANNEL_DETAILS_INST_TXT@hostPatchResourceBundle"
        styleClass="OraInstructionText"/>
    </uix:rowLayout>
  </uix:tableLayout>

  <uix:header textBinding="PACKAGES@hostPatchResourceBundle">

      <uix:tableLayout>
        <uix:rowLayout>
          <uix:styledText
            textBinding="PKGS_TABLE_INST_TXT@hostPatchResourceBundle"
            styleClass="OraInstructionText"/>
        </uix:rowLayout>
      </uix:tableLayout>

    <uix:spacer height = "10"/>

      <%--
        - This table uses partial renderring mode. So id attribute is must. Also
        - partial renderring requires "/enablePPR.jspf" to be included, which is
        - inculded in the template.jspf
        --%>
      <uix:table
        width="80%"
        name="pkgsTable"
        id="pkgsTableID"
        summaryBinding="PKGS_TABLE_SUMMARY@hostPatchResourceBundle"
        partialRenderMode="self"
        formSubmitted="true"
        alternateTextBinding="MSG_NO_PKGS_FOUND@hostPatchResourceBundle"
        tableDataBinding="pkgsTableRows@ulnChannelDetailsBean@servletRequest"
        valueBinding="pkgsTableCurrentValue@ulnChannelDetailsBean@servletRequest"
        minValueBinding="pkgsTableMinValue@ulnChannelDetailsBean@servletRequest"
        blockSizeBinding="blockSize@ulnChannelDetailsBean@servletRequest"
        maxValueBinding="pkgsTableMaxValue@ulnChannelDetailsBean@servletRequest"
        columnHeaderDataBinding="pkgsTableColHeaders@ulnChannelDetailsBean@servletRequest">

        <uix:tableActions>
          <uix:button
            name="addPkg"
            destinationBinding="addPkgPageURL@ulnChannelDetailsBean@servletRequest"
            textBinding="ADD@commonResourceBundle"/>
        </uix:tableActions>

        <uix:tableSelection>
          <uix:multipleSelection 
            shortDescBinding="SELECT@commonResourceBundle">

            <uix:submitButton
              name="event"
              value="skip"
              formNameBinding="formName@servletRequest"
              textBinding="SKIP@hostPatchResourceBundle"/>

              <uix:submitButton
                name="event"
                value="remove"
                formNameBinding="formName@servletRequest"
                textBinding="REMOVE@commonResourceBundle"/>

          </uix:multipleSelection>
        </uix:tableSelection>

        <uix:tableFormat tableBanding="rowBanding"/>

        <uix:columnHeaderStamp>
          <uix:sortableHeader
            textBinding="text"
            sortableBinding="sortable">
          </uix:sortableHeader>
        </uix:columnHeaderStamp>

        <uix:styledText textBinding="pkgName"/>
        <uix:styledText textBinding="version"/>
        <uix:styledText textBinding="release"/>

        <uix:column>
          <uix:columnFormat
            columnDataFormat="iconButtonFormat"/>
          <uix:image
            sourceBinding="imgSrc"
            shortDescBinding="status"/>
        </uix:column>

        <uix:styledText textBinding="synopsis"/>

        </uix:table>
        <uix:separator/>
      </uix:header>

      <uix:header textBinding="SKIP_LIST@hostPatchResourceBundle">

        <uix:tableLayout>
          <uix:rowLayout>
            <uix:styledText
              textBinding="SKIP_LIST_INST_TXT@hostPatchResourceBundle"
              styleClass="OraInstructionText"/>
          </uix:rowLayout>
        </uix:tableLayout>

        <uix:spacer height = "10"/>

        <uix:table
          width="80%"
          name="skipPkgsTable"
          id="skipPkgsTableID"
          summaryBinding="SKIP_PKGS_TABLE_SUMMARY@hostPatchResourceBundle"
          partialRenderMode="self"
          formSubmitted="true"
          alternateTextBinding="NO_PKGS_FOUND@hostPatchResourceBundle"
          tableDataBinding="skipPkgsTableRows@ulnChannelDetailsBean@servletRequest"
          valueBinding="skipPkgsTableCurrentValue@ulnChannelDetailsBean@servletRequest"
          minValueBinding="skipPkgsTableMinValue@ulnChannelDetailsBean@servletRequest"
          blockSizeBinding="blockSize@ulnChannelDetailsBean@servletRequest"
          maxValueBinding="skipPkgsTableMaxValue@ulnChannelDetailsBean@servletRequest"
          columnHeaderDataBinding="skipPkgsTableColHeaders@ulnChannelDetailsBean@servletRequest">

          <uix:tableSelection>
            <uix:multipleSelection 
              shortDescBinding="SELECT@commonResourceBundle">

                <uix:submitButton
                  name="event"
                  value="remove"
                  formNameBinding="formName@servletRequest"
                  textBinding="REMOVE@commonResourceBundle"/>

            </uix:multipleSelection>
          </uix:tableSelection>

          <uix:tableFormat tableBanding="rowBanding"/>

          <uix:columnHeaderStamp>
            <uix:sortableHeader
              textBinding="text"
              sortableBinding="sortable">
            </uix:sortableHeader>
          </uix:columnHeaderStamp>

          <uix:styledText textBinding="pkgName"/>
        </uix:table>
        <uix:separator/>
      </uix:header>
  
  <uix:header textBinding="CFG_FILES@hostPatchResourceBundle">

    <uix:tableLayout>
      <uix:rowLayout>
        <uix:styledText
          textBinding="CFG_FILES_TABLE_INST_TXT@hostPatchResourceBundle"
          styleClass="OraInstructionText"/>
      </uix:rowLayout>
    </uix:tableLayout>

    <uix:spacer height = "10"/>

    <%--
      - This table uses partial renderring mode. So id attribute is must. Also
      - partial renderring requires "/enablePPR.jspf" to be included, which is
      - inculded in the template.jspf
      --%>
    <uix:table
      width="80%"
      name="configFilesTable"
      id="configFilesTableID"
      summaryBinding="CFG_FILES_TABLE_SUMMAYR@hostPatchResourceBundle"
      partialRenderMode="self"
      formSubmitted="true"
      alternateTextBinding="MSG_NO_CFG_FILE_FOUND@hostPatchResourceBundle"
      tableDataBinding="cfgFilesTableRows@ulnChannelDetailsBean@servletRequest"
      valueBinding="cfgFilesTableCurrentValue@ulnChannelDetailsBean@servletRequest"
      minValueBinding="cfgFilesTableMinValue@ulnChannelDetailsBean@servletRequest"
      blockSizeBinding="blockSize@ulnChannelDetailsBean@servletRequest"
      maxValueBinding="cfgFilesTableMaxValue@ulnChannelDetailsBean@servletRequest"
      columnHeaderDataBinding="cfgFilesTableColHeaders@ulnChannelDetailsBean@servletRequest">

      <uix:tableFormat tableBanding="rowBanding"/>

      <uix:tableActions>
        <uix:button
          name="addCfgFile"
          destinationBinding="addCfgFilePageURL@ulnChannelDetailsBean@servletRequest"
          textBinding="ADD@commonResourceBundle"/>
      </uix:tableActions>

      <uix:tableSelection>
        <uix:multipleSelection 
          shortDescBinding="SELECT@commonResourceBundle">

          <uix:submitButton
            name="event"
            value="remove"
            formNameBinding="formName@servletRequest"
            textBinding="REMOVE@commonResourceBundle"/>

            <uix:submitButton
              name="event"
              value="deploy"
              formNameBinding="formName@servletRequest"
              textBinding="DEPLOY@hostPatchResourceBundle"/>

        </uix:multipleSelection>
      </uix:tableSelection>

      <uix:columnHeaderStamp>
        <uix:sortableHeader
          textBinding="text"
          sortableBinding="sortable">
        </uix:sortableHeader>
      </uix:columnHeaderStamp>

      <uix:styledText textBinding="filename"/>
      <uix:styledText textBinding="owner"/>
      <uix:styledText textBinding="permissions"/>

      <uix:column>
        <uix:columnFormat
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat"/>
        <uix:styledText textBinding="revision"/>
      </uix:column>

      <uix:column>
        <uix:columnFormat
          cellNoWrapFormat="true"
          columnDataFormat="numberFormat"/>
        <uix:styledText textBinding="bytes"/>
      </uix:column>

      <uix:styledText textBinding="lastModified"/>

    </uix:table>
    <uix:spacer height="5"/>
  </uix:header>
  

</uix:buildTree>

<%@ include file="template.jspf" %>
